package com.pangding.web.V2.service.impl;

import com.pangding.web.V2.dao.SystemStopDao;
import com.pangding.web.V2.service.SystemStopService;
import com.pangding.web.vo.system.pd.SystemStopVo;
import com.pangding.web.vo.system.req.SystemStopReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SystemStopServiceImpl implements SystemStopService {

    private final SystemStopDao systemStopDao;

    public SystemStopServiceImpl(SystemStopDao systemStopDao) {
        this.systemStopDao = systemStopDao;
    }

    @Override
    public SystemStopVo findSystemStop(SystemStopReqVo req){
        SystemStopVo systemStopVo = systemStopDao.load(req, SystemStopVo.class);
        return systemStopVo;
    }

    public List<SystemStopVo> findSystemStopList(SystemStopReqVo req){
        List<SystemStopVo> systemStopList = systemStopDao.loadList(req, SystemStopVo.class);
        return systemStopList;
    }


    public void save(SystemStopReqVo req){
        if(StringHelper.isEmpty(req.getStopId())){
            SystemStopVo systemStopVo = new SystemStopVo();
            ObjectHelper.writeWithFromClass(systemStopVo, req);
            systemStopVo.setStopId(StringHelper.getNewID());
            systemStopVo.setCreateTime(DateHelper.getNow());
            systemStopDao.create(systemStopVo);
        }else{
            SystemStopVo systemStopVo = systemStopDao.load(req.getStopId(), SystemStopVo.class);
            if(StringHelper.isEmpty(systemStopVo)){
                throw new CodeException("99", "未查询到修改的标识");
            }else{
                ObjectHelper.writeWithFromClass(systemStopVo, req);
                systemStopVo.setCreateTime(DateHelper.getNow());
                systemStopDao.update(systemStopVo);
            }

        }

    }

    public void del(SystemStopReqVo req){
        systemStopDao.remove(req);
    }


}
