package com.pangding.web.V2.web;

import com.pangding.web.V2.service.SystemStopService;
import com.pangding.web.vo.system.pd.SystemStopVo;
import com.pangding.web.vo.system.req.SystemStopReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/systemStop", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "停止访问系统", description = "停止访问系统")
public class SystemStopController {

    private final SystemStopService systemStopService;

    public SystemStopController(SystemStopService systemStopService) {
        this.systemStopService = systemStopService;
    }

    @RequestMapping(value = "/findSystemStop")
    @ApiOperation(value = "查询系统停止标识", notes = "返回系统停止标识.")
    public ResponseResult<SystemStopVo> findSystemStop(@RequestBody SystemStopReqVo req) {
//        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
//                .notBlankCheck("codeType", req.getCodeType())
//                .checkException();
        return ResponseResult.result(systemStopService.findSystemStop(req));
    }

    @RequestMapping(value = "/findSystemStopList")
    @ApiOperation(value = "查询系统停止标识列表", notes = "返回系统停止标识列表.")
    public ResponseResult<List<SystemStopVo>> findSystemStopList(@RequestBody SystemStopReqVo req) {

        return ResponseResult.result(systemStopService.findSystemStopList(req));
    }

    @RequestMapping(value = "/saveSystemStop")
    @ApiOperation(value = "保存系统停止标识", notes = "返回成功.")
    public ResponseResult saveSystemStop(@RequestBody SystemStopReqVo req) {

        systemStopService.save(req);
        return ResponseResult.resultAllowNull("");
    }

    @RequestMapping(value = "/delSystemStop")
    @ApiOperation(value = "删除系统停止标识", notes = "返回成功.")
    public ResponseResult delSystemStop(@RequestBody SystemStopReqVo req) {

        systemStopService.del(req);
        return ResponseResult.resultAllowNull("");
    }


}
