package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.CompanyMoneyService;
import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.pangding.web.util.DateUtil;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.order.req.back.CashWithdrawalBackReqVo;
import com.pangding.web.vo.order.res.CapitalFlowListResVo;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyMoneyTotalResVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

import static com.yanzuoguang.util.helper.DateHelper.getCurDate;


/**
 * @Author zhangjinyao
 * @create 2019/6/18 19:53
 */
@RestController
@RequestMapping(value = "/finance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "余额", description = "余额")
public class FinanceController {
    @Autowired
    private FinanceService financeService;
    @Autowired
    private CompanyMoneyService companyMoneyService;

    /**
     * 查询订单列表PageSizeData<CapitalFlowResVo>
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/findCapitalFlowList")
    public ResponseResult<CapitalFlowListResVo> findCapitalFlowList(@RequestBody CapitalFlowReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        if ("10001".equals(req.getCompanyId())) {
            req.setCompanyId("");
        }
        if (!StringHelper.isEmpty(req.getDateType()) && 1 == req.getDateType()) {
            req.setStartPlayDate(req.getStartDate().substring(0, 10) + " 00:00:00");
            req.setEndPlayDate(req.getEndDate().substring(0, 10) + " 23:59:59");
            req.setStartDate("");
            req.setEndDate("");
        }
        if (!StringHelper.isEmpty(req.getDateType()) && 0 == req.getDateType()) {
            /*入参添加年月日*/
            req.setStartOrderTime(req.getStartDate().substring(0, 10) + " 00:00:00");
            req.setEndOrderTime(req.getEndDate().substring(0, 10) + " 23:59:59");
            req.setStartDate("");
            req.setEndDate("");
        }
        CapitalFlowListResVo capitalFlowListResVo = financeService.findCapitalFlowList(req);
        return ResponseResult.result(capitalFlowListResVo);
    }

    @PostMapping(value = "/withdrawal")
    @ApiOperation(value = "公司余额查询", notes = "返回公司余额信息")
    public ResponseResult<WithdrawalResVo> withdrawal(@RequestBody WithdrawalReqVo reqVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(financeService.withdrawal(reqVo));
    }

    /**
     * 提现申请
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/applyWithdrawal")
    @ApiOperation(value = "提现申请", notes = "返回提现申请结果")
    public ResponseResult<CapitalFlowReqVo> applyWithdrawal(@RequestBody CapitalFlowReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("companyName", req.getCompanyName())
                .notBlankCheck("bankId", req.getBankId())
                .notBlankCheck("bankCardCode", req.getBankCardCode())
                .notBlankCheck("orderMoney", req.getOrderMoney())
                .checkException();
        return financeService.applyWithdrawal(req);
    }

    /**
     * 提现回调
     */
    @RequestMapping(value = "/withdrawalBack")
    public ResponseResult<String> withdrawalBack(@RequestBody CashWithdrawalBackReqVo req) {
        return financeService.withdrawalBack(req);
    }

    /**
     * 转账
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/divideSettlment")
    @ApiOperation(value = "转账", notes = "返回转账结果")
    public ResponseResult<CapitalFlowReqVo> divideSettlment(@RequestBody CapitalFlowReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("companyName", req.getCompanyName())
                .notBlankCheck("bankId", req.getBankId())
                .notBlankCheck("orderMoney", req.getOrderMoney())
                .checkException();
        return financeService.applyWithdrawal(req);
    }

    @RequestMapping(value = "findCompanyMoneyList")
    @ApiOperation(value = "找到公司资金汇总列表", notes = "返回公司资金汇总列表")
    public ResponseResult<CompanyMoneyTotalResVo> findCompanyMoneyList(@RequestBody CompanyMoneyReqVo req) {
//        CheckerHelper.newInstance()
//                .notBlankCheck("companyId", req.getCompanyId())
//                .notBlankCheck("startDate", req.getStartDate())
//                .notBlankCheck("endDate", req.getEndDate())
//                .checkException();
        Date now = DateHelper.getDateTime(DateHelper.toDay(DateHelper.getDateTime(getCurDate())));
        if(!StringHelper.isEmpty(req.getStartDate())){
            Date start = DateHelper.getDateTime(DateHelper.toDay(DateHelper.getDateTime(req.getStartDate())));
            if (DateHelper.compare(start, now) == 0) {
                req.setStartDate(DateUtil.getNextDateStr(req.getStartDate()));
            }
        }
        if(!StringHelper.isEmpty(req.getEndDate())){
            Date end = DateHelper.getDateTime(DateHelper.toDay(DateHelper.getDateTime(req.getEndDate())));
            if (DateHelper.compare(end, now) == 0) {
                req.setEndDate(DateUtil.getBeforDateStr(req.getEndDate()));
            }
        }

        return ResponseResult.result(companyMoneyService.findCompanyMoney(req));
    }

    @RequestMapping(value = "/findLastInfo")
    @ApiOperation(value = "查询最后一条数据的finalMoney", notes = "查询最后一条数据的finalMoney")
    public ResponseResult<CompanyMoneyVo> findLastInfo(@RequestBody CompanyMoneyReqVo req) {
        return ResponseResult.result(companyMoneyService.findLastInfo(req));
    }


}
