package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CapitalFlowDao;
import com.pangding.web.vo.order.pd.CapitalFlowVo;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.order.res.CapitalFlowResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CapitalFlowDaoImpl extends BaseDaoImpl implements CapitalFlowDao {

    private static final String QUERY_LIST = "QUERY_CAPITAL_FLOW_LIST";

    private static final String QUERY_LIST_TOTAL = "QUERY_LIST_TOTAL";

    @Override
    protected void init() {
        register(CapitalFlowVo.class);
        table.add(QUERY_LIST, "SELECT * FROM pd_capital_flow  where  1=1 {WHERE} order by time desc")
                .add("companyId"," AND company_id = ? ")
                .add("companyName"," AND company_name LIKE concat(?,'%') ")
                .add("merchantName"," AND merchant_name LIKE concat(?,'%') ")
                .add("productName"," AND product_name LIKE concat(?,'%') ")
                .add("orderType"," AND order_type = ? ")
                .add("startOrderTime", " AND order_time >= ? ")
                .add("endOrderTime", " AND order_time <= ? ")
                .add("startPlayDate", " AND play_date >= ? ")
                .add("endPlayDate", " AND play_date <= ? ")
                .add("startDate", " AND time >= ? ")
                .add("endDate", " AND time <= ? ")
                .add("orderId", " AND order_id = ? ")
                .add("category", " AND category = ? ")
                .add("categoryList", " AND category in (?) ")
                .add("status"," AND status = ? ");

        table.add(QUERY_LIST_TOTAL, "SELECT SUM(CASE WHEN category = 0 THEN order_money ELSE 0 END) AS orderMoney," +
                "SUM(CASE WHEN category = 0 THEN order_fee ELSE 0 END) AS orderFee," +
                "SUM(CASE WHEN category = 0 THEN actual_money ELSE 0 END) AS realMoney," +
                "SUM(CASE WHEN category = 1 THEN order_money ELSE 0 END) AS withdrawalAmount," +
                "SUM(CASE WHEN category = 3 THEN actual_money ELSE 0 END) AS refundMoney," +
                "SUM(CASE WHEN category <> 3 THEN actual_money ELSE 0 END) - SUM(CASE WHEN category = 1 THEN order_money ELSE 0 END) as actualMoney" +
                " FROM pd_capital_flow  where  1=1 {WHERE} order by time desc")
                .add("companyId"," AND company_id = ? ")
                .add("companyName"," AND company_name LIKE concat(?,'%')")
                .add("merchantName"," AND merchant_name LIKE concat(?,'%') ")
                .add("productName"," AND product_name LIKE concat(?,'%') ")
                .add("orderType"," AND order_type = ? ")
                .add("startOrderTime", " AND order_time >= ? ")
                .add("endOrderTime", " AND order_time <= ? ")
                .add("startPlayDate", " AND play_date >= ? ")
                .add("endPlayDate", " AND play_date <= ? ")
                .add("startDate", " AND time >= ? ")
                .add("endDate", " AND time <= ? ")
                .add("orderId", " AND order_id = ? ")
                .add("category", " AND category = ?")
                .add("categoryList", " AND category in (?) ")
                .add("status"," AND status = ? ");
    }

    @Override
    public PageSizeData<CapitalFlowResVo> findCapitalFlowList(CapitalFlowReqVo req){
        return this.queryPage(CapitalFlowResVo.class, req, QUERY_LIST, req);
    }

    @Override
    public CapitalFlowResVo findCapitalFlowTotal(CapitalFlowReqVo req){
        return this.queryFirst(CapitalFlowResVo.class, QUERY_LIST_TOTAL, req);
    }
}
