package com.pangding.web.report.service.impl;

import com.pangding.web.authority.service.CompanyMoneyService;
import com.pangding.web.report.service.V2IndexService;
import com.pangding.web.vo.order.req.report.DataAnalysisBaseReqVo;
import com.pangding.web.vo.order.req.report.ReportDayFlowReqVo;
import com.pangding.web.vo.order.res.report.AnalysisBaseResVo;
import com.pangding.web.vo.order.res.report.DataAnalysisBaseResVo;
import com.pangding.web.vo.order.res.report.ReportDayFlowResVo;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyMoneyTotalResVo;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.MapRow;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class V2IndexServiceImpl implements V2IndexService {

    private final CompanyMoneyService companyMoneyService;

    public V2IndexServiceImpl(CompanyMoneyService companyMoneyService) {
        this.companyMoneyService = companyMoneyService;
    }

    /**
     * 首页顶部汇总数据加载
     * 提现余额取值：判断最后日期 == 当天 取值=当天初始值-当天提现值；不是当天日期，取值= 最终值；
     * 经营流水取值：判断日期==当天，取值=当天收益-当天退款；最后一条日期 不等于 当日，取值 = 0；
     * 交易订单和经营流水取值一样
     *
     * @param reqVo
     * @return
     */
    @Override
    public ReportDayFlowResVo indexDataV2(ReportDayFlowReqVo reqVo) {
        ReportDayFlowResVo result = new ReportDayFlowResVo(0, 0, 0,
                0d, 0d, 0d);

        // 查询公司资金最新的一条数据  可提现余额 当日经营流水 当日交易订单
        CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
        companyMoneyReqVo.setCompanyId(reqVo.getCompanyId());
        CompanyMoneyVo companyMoneyLast = companyMoneyService.findLastInfo(companyMoneyReqVo);
        CompanyMoneyVo companyMoneyTotal = companyMoneyService.findTotal(companyMoneyReqVo);
        if (!StringHelper.isEmpty(companyMoneyLast)) {
            // 最新一条数据为当天的数据
            if (companyMoneyLast.getDailyDate().equals(DateHelper.getToday())) {
                double todayBalance = BigDecimal.valueOf(companyMoneyLast.getInitMoney())
                        .add(BigDecimal.valueOf(companyMoneyLast.getOutMoney())).doubleValue();
                result.setTodayBalance(todayBalance);
                double todayMoney = BigDecimal.valueOf(companyMoneyLast.getInMoney())
                        .add(BigDecimal.valueOf(companyMoneyLast.getRefundMoney())).doubleValue();
                result.setTodayPdOrderMoney(todayMoney);
                result.setTodayOrderNum(companyMoneyLast.getInNumber() - companyMoneyLast.getRefundNumber());
            } else {
                result.setTodayBalance(companyMoneyLast.getFinalMoney());
            }
        }
        // 查询汇总金额 提现汇总 经营汇总 交易订单 跨界汇总
        if (!StringHelper.isEmpty(companyMoneyTotal)) {
            // 最新一条数据为当天的数据
            double balance = companyMoneyLast.getOutMoney() == null ? 0 : Math.abs(companyMoneyLast.getOutMoney());
            result.setBalance(balance);
            double todayMoney = BigDecimal.valueOf(companyMoneyLast.getInMoney())
                    .add(BigDecimal.valueOf(companyMoneyLast.getRefundMoney())).doubleValue();
            result.setPdOrderMoney(todayMoney);
            result.setOrderNum(companyMoneyLast.getInNumber() - companyMoneyLast.getRefundNumber());
        }
        return result;
    }


    @Override
    public DataAnalysisBaseResVo capitalAndOrderDay(DataAnalysisBaseReqVo req) {

        DataAnalysisBaseResVo res = new DataAnalysisBaseResVo();
        ReportDayFlowReqVo reqVo = new ReportDayFlowReqVo();
        String monthStart = DateHelper.getDateTimeString(DateHelper.getMonthStart(DateHelper.getCurDate())).substring(0, 10);
        String monthEnd = DateHelper.getDateTimeString(DateHelper.getMonthEnd(DateHelper.getCurDate())).substring(0, 10);
        reqVo.setQueryStartTime(monthStart);
        reqVo.setQueryEndTime(monthEnd);

        req.setQueryStartTime(monthStart);
        req.setQueryEndTime(monthEnd);

        CompanyMoneyReqVo companyMoneyReqVo = new CompanyMoneyReqVo();
        companyMoneyReqVo.setCompanyId(reqVo.getCompanyId());
        companyMoneyReqVo.setStartDate(monthStart);
        companyMoneyReqVo.setEndDate(monthEnd);
        List<CompanyMoneyVo> companyMoneyVoList = companyMoneyService.findCompanyMoneyList(companyMoneyReqVo);

        req.setCreateDateBegin(monthStart);
        req.setCreateDateEnd(monthEnd);
        // 经营流水
        List<MapRow> moneyList = new ArrayList<>();
        // 交易订单
        List<MapRow> orderNumList = new ArrayList<>();
        // 用户订单
        List<MapRow> userList = new ArrayList<>();
        for (String year : req.getYearList()) {
            MapRow map1 = new MapRow();
            MapRow map2 = new MapRow();

            Date date2 = DateHelper.getDateTime(req.getCreateDateBegin());
            Date dateEnd1 = DateHelper.getDateTime(req.getCreateDateEnd());
            long time1 = DateHelper.betweenDay(date2, dateEnd1);

            String yearTime1 = DateHelper.getDateTimeString(date2).substring(0, 10);
            for (int i = 0; i <= time1; i++) {
                if (i > 0) {
                    date2 = DateHelper.addDay(date2, 1);
                    yearTime1 = DateHelper.getDateTimeString(date2).substring(0, 10);
                }
                if (companyMoneyVoList.size() - 1 == time1) {
                    double money = BigDecimal.valueOf(companyMoneyVoList.get(i).getInMoney())
                            .add(BigDecimal.valueOf(companyMoneyVoList.get(i).getRefundMoney())).doubleValue();
                    map1.put(yearTime1, money);
                    int number = companyMoneyVoList.get(i).getInNumber() - companyMoneyVoList.get(i).getRefundNumber();
                    map2.put(yearTime1, number);
                } else {
                    if (companyMoneyVoList.size() > 0) {
                        for (CompanyMoneyVo companyMoneyVo : companyMoneyVoList) {
                            if (yearTime1.equals(companyMoneyVo.getDailyDate())) {
                                double money = BigDecimal.valueOf(companyMoneyVo.getInMoney())
                                        .add(BigDecimal.valueOf(companyMoneyVo.getRefundMoney())).doubleValue();
                                int number = companyMoneyVo.getInNumber() - companyMoneyVo.getRefundNumber();
                                map1.put(yearTime1, money);
                                map2.put(yearTime1, number);
                                break;
                            } else {
                                map1.put(yearTime1, 0);
                                map2.put(yearTime1, 0);
                            }
                        }
                    } else {
                        map1.put(yearTime1, 0);
                        map2.put(yearTime1, 0);
                    }
                }
            }

//
//            //用户分析
//            List<AnalysisBaseResVo> result2 = userAccumulateDao.loadMonthUser(req);
//
//
//            MapRow map3 = new MapRow();
//            Date dateStart = DateHelper.getDateTime(req.getCreateDateBegin());
//            Date dateEnd = DateHelper.getDateTime(req.getCreateDateEnd());
//            long time = DateHelper.betweenDay(dateStart, dateEnd);
//
//            Date date1 = DateHelper.getDateTime(DateHelper.toDay(dateStart));
//            String yearTime = DateHelper.getDateTimeString(date1).substring(0, 10);
//
//            if (result2.size() == time+1) {
//                for (int i = 0; i <= time; i++) {
//                    if (i > 0) {
//                        date1 = DateHelper.addDay(date1, 1);
//                        yearTime = DateHelper.getDateTimeString(date1).substring(0, 10);
//                    }
//                    map3.put(yearTime, result2.get(i).getUserNum());
//                }
//            } else {
//                for (int i = 0; i <= time; i++) {
//                    if (i > 0) {
//                        date1 = DateHelper.addDay(date1, 1);
//                        yearTime = DateHelper.getDateTimeString(date1).substring(0, 10);
//                    }
//                    if (result2.size() > 0) {
//                        for (AnalysisBaseResVo analysis : result2) {
//                            if (yearTime.equals(analysis.getYears())) {
//                                map3.put(yearTime, analysis.getUserNum());
//                                break;
//                            } else {
//                                map3.put(yearTime, 0);
//                            }
//                        }
//                    } else {
//                        map3.put(yearTime, 0);
//                    }
//                }
//            }

            moneyList.add(map1);
            orderNumList.add(map2);
//            userList.add(map3);
        }
        res.setMoneyList(moneyList);
        res.setOrderList(orderNumList);
        res.setUserList(userList);
        return res;
    }


}
