package com.pangding.web.authority.controller;

import com.pangding.web.authority.vo.reqvo.RegisterIndividualReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterUserReqVo;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.LoginReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 11:26
 */
@RestController
@RequestMapping(value="/mobile")
public class MobileRegisterController {

    @Autowired
    RegisterService registerServiceImpl;

    /**
     * 验证注册第一页数据的合法性并保存
     *
     * @param registerUserReqVo
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> saveUser(@RequestBody RegisterUserReqVo registerUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("reqVo",registerUserReqVo)
                .checkException()
                .notBlankCheck("account",registerUserReqVo.getAccount())
                .notBlankCheck("password",registerUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",registerUserReqVo.getConfirmPassword())
                .notBlankCheck("companyType",registerUserReqVo.getCompanyType())
                .notBlankCheck("invitationCode",registerUserReqVo.getInvitationCode())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveUser(registerUserReqVo));
    }

    /**
     * 验证注册第二页数据的合法性并保存
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/individual", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveIndividual(@RequestBody RegisterIndividualReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("reqVo",reqVo)
                .checkException()
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("extraChoseOne",reqVo.getExtraChoseOne())
                .notBlankCheck("extraChosetwo",reqVo.getExtraChoseTwo())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .checkException();
        registerServiceImpl.saveIndividual(reqVo);
        return new ResponseResult();
    }




    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult login(@RequestBody LoginReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("reqVo",reqVo)
                .checkException()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("pass",reqVo.getPassword())
                .checkException();
        registerServiceImpl.login(reqVo);
        return new ResponseResult();
    }
}
