package com.pangding.web.authority.controller;


import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping(value = "/user")
public class UserController {

    @Autowired
    UserService userServiceImpl;

    /**
     * 新增用户
     * @param webUserReqVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveUser(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("reqVo",webUserReqVo)
                .checkException()
                .notBlankCheck("account",webUserReqVo.getAccount())
                .notBlankCheck("password",webUserReqVo.getPassword())
                .checkPhoneNo("phone",webUserReqVo.getPhone())
                .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                .notBlankCheck("status",webUserReqVo.getStatus())
                .checkException();
        userServiceImpl.saveUser(webUserReqVo);
        return new ResponseResult();
    }

    /**
     * 修改用户信息
     * @param //userDto
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult updateUser(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("reqVo",webUserReqVo)
                .checkException()
                .notBlankCheck("account",webUserReqVo.getAccount())
                .notBlankCheck("password",webUserReqVo.getPassword())
                .checkPhoneNo("phone",webUserReqVo.getPhone())
                .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                .notBlankCheck("status",webUserReqVo.getStatus())
                .checkException();
        userServiceImpl.updateUser(webUserReqVo);
        return new ResponseResult();
    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebUserResVo>> listUsers(ListUserReqVo reqVo){
        return ResponseResult.result(userServiceImpl.getWebUserResVoList(reqVo));
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<WebUserResVo> user(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("req",webUserReqVo)
                .checkException()
                .notBlankCheck("userId",webUserReqVo.getId())
                .checkException();
        return ResponseResult.result(userServiceImpl.getUserById(webUserReqVo.getId()));
    }

}
