package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.vo.CompanyVo;
import com.yanzuoguang.util.base.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyServiceImpl implements CompanyService{

    @Autowired
    private CompanyDao companyDao;

    @Override
    public void updateCompayStatus(CompanyVo companyVo){
        CompanyVo company = companyDao.load(companyVo.getId(), CompanyVo.class);
        ObjectHelper.writeWithFrom(company, companyVo);
        companyDao.update(company);
    }

    @Override
    public CompanyVo saveCompany(CompanyVo company){
        CompanyVo companyVo = companyDao.load(company.getId(), CompanyVo.class);
        if(null != companyVo){
            companyDao.update(company);
        }else{
            companyDao.save(company);
        }
        return companyDao.load(company.getId(), CompanyVo.class);
    }

    @Override
    public void updateCompany(CompanyVo companyVo){
        companyDao.update(companyVo);
    }


}
