package com.pangding.web;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

/**
 * 日志自动启动服务
 * @author Administrator
 */
@SpringBootApplication(scanBasePackages = {
        "com.pangding.*",
        "com.yanzuoguang.*",
        "org.springframework.jdbc.*"
})
@EnableEurekaClient
@EnableFeignClients(basePackages={
        "com.pangding.*",
        "com.yanzuoguang.*"
})
public class UserApp {

    public static void main(String[] args) {
        SpringApplication.run(UserApp.class, args);
    }
}