package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.*;
import com.pangding.web.vo.system.res.company.FindCompanyBalanceResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;

import java.util.List;

/**
 * @author Administrator
 */
public interface CompanyService{

    /**
     * 修改公司信息
     * @param companyVo
     */
    void updateCompanyStatus(CompanyVo companyVo);

    /**
     * 分页查询公司信息
     * @param reqVo 继承了分页对象
     * @return 公司列表分页对象
     */
    PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo);

    /**
     * 胖丁查询用户，公司和公司扩展表信息以及银行卡列表
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司，公司扩展表和银行卡列表信息的对象
     */
    CompanyResVo pdGetDetail(CompanyGetReqVo reqVo);

    /**
     * 根据请求的数据返回对应的供应商或是接口商列表
     * @param reqVo
     * @return
     */
    List<CompanyVo> productOrInterface(ProductOrInterfaceReqVo reqVo);

    /**
     * 商户查看详情，根据公司id返回用户信息和公司主表信息
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司主表信息的对象
     */
    CompanyResVo getDetail(CompanyGetReqVo reqVo);

    /**
     * 新增/修改公司信息
     * @param reqVo 公司以及公司扩展表信息
     * @return 公司id
     */
    SaveCompanyResVo saveCompany(SaveCompanyReqVo reqVo);

    /**
     * 添加公司提交按钮
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    SaveCompanyResVo companySubmit(SaveCompanyReqVo reqVo);

    /**
     * 修改公司审核状态
     * @param reqVo 封装了公司id 的请求对象
     * @return
     */
    void updateExamine(UpdateExamineReqVo reqVo);

    /**
     * 保存银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    String saveBank(CompanyBankCardVo reqVo);

    /**
     * 删除银行卡
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    void deleteBank(CompanyBankCardVo reqVo);

   /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo);

    /**
     * 设置该银行卡为默认支付，并取消其他银行卡的默认
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    void setDefault(CompanyBankCardVo reqVo);

    /**y
     * 我的二维码页面
     * @param reqVo 公司扩展表请求对象
     * @return 公司主表信息
     */
    CompanyVo myQrCodeUrl(CompanyGetReqVo reqVo);

    /**
     * 获取二维码url，有则直接返回，没有则调用微信服务生成url
     * @param reqVo 封装了公司id，页面选项的请求对象
     * @return 二维码url
     */
    String generateQrCodeUrl(GenerateQrCodeUrlReqVo reqVo);

    /**
     * 获取银行卡列表
     * @param reqVo 继承了分页对象，含公司id
     * @return 银行卡列表分页对象
     */
    PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo);

    /**
     * 添加用户
     * @param reqVo 封装了用户信息和用户角色信息的请求对象
     * @return 用户id
     */
    String saveUser(WebUserReqVo reqVo) throws Exception;

    /**
     * 批量删除用户
     * @param reqVo 封装了用户id列表的请求对象
     * @return
     */
    void batchDelete(BatchDeleteReqVo reqVo);

    /**
     * 批量更新用户信息
     * @param reqVo 封装了用户列表的请求对象
     * @return
     */
    void batchUpdate(BatchUpdateReqVo reqVo) throws Exception;

    /**
     * 通过公司id查询该公司邀请的公司
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    PageSizeData<CompanyVo> myInvite(ListCompanyReqVo reqVo);

    String invitation(InvitationReqVo reqVo);

    /**
     * 根据二维码源码获取公司数据
     * @param reqVo 封装了二维码源码的请求对象
     * @return
     */
    GetCompanyResVo getCompanyByQrCode(GetCompanyByQrCodeReqVo reqVo);

    /**
     * 获得公司分润信息
     * @param req
     * @return
     */
    List<GetCompanyDivideResVo> findCompanyDivideInfo(CompanyDivideReqVo req);

    /**
     * 检查邀请码是否真实存在
     * @param reqVo
     * @return
     */
    CompanyVo checkInvitationCode(CheckInvitationCodeReqVo reqVo);

    /**
     * 审核公司
     * @param reqVo
     * @return
     */
    void examineConfig(ExamineConfigReqVo reqVo);

    ResponseResult<String> updateCompanyMoney(UpdateCompanyMoneyReqVo req);


    /**
     * 找到公司信息及公司余额明细
     * @param req
     * @return
     */
    FindCompanyBalanceResVo findCompanyBalance(com.pangding.web.vo.system.req.company.CompanyReqVo req);
}
