package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.PayFeign;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.service.*;
import com.pangding.web.authority.util.*;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.AuthorityListByLevelResVo;
import com.pangding.web.authority.vo.resvo.LoginCompanyResVo;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;
import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.yanzuoguang.token.TokenHelper;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDaoImpl;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    UserRoleDao userRoleDaoImpl;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    VerifyCodeService verifyCodeServiceImpl;
    @Autowired
    RoleAuthorityDao roleAuthorityDaoImpl;
    @Autowired
    AuthorityDao authorityDaoImpl;
    @Autowired
    AuthorityService authorityServiceImpl;
    @Autowired
    PayFeign payFeign;
    @Autowired
    private TokenService tokenService;

    /**
     * 判断注册编码是否存在
     *
     * @param invitationCode 注册编码
     * @return 若不存在，返回null，存在则返回CompanyExtendVo对象
     */
    @Override
    public CompanyExtendVo checkInvitationCode(String invitationCode) {
        CompanyExtendGetReqVo reqVo = new CompanyExtendGetReqVo();
        reqVo.setInvitationCode(invitationCode);
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        return companyExtendVo;
    }

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) throws Exception {

        // 检查账户是否合法
        userServiceImpl.isValid(registerUserReqVo.getAccount());

        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(registerUserReqVo.getAccount());
        // 检查用户名是否存在
        UserVo userVoCheck = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null != userVoCheck){
            throw new CodeException("用户名"+registerUserReqVo.getAccount()+"已存在");
        }

        /*通过私钥将rsa加密的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(registerUserReqVo.getPassword(),RsaConstant.privateKey);
        String confirmPassword = RSAUtils.decryptionByPrivateKey(registerUserReqVo.getConfirmPassword(),RsaConstant.privateKey);

        if (!StringHelper.compare(password,confirmPassword)){
            throw new CodeException("确认密码错误");
        }

        CompanyExtendVo companyExtendVo = checkInvitationCode(registerUserReqVo.getInvitationCode());
        if (null == companyExtendVo){
            throw new CodeException("注册编码错误");
        }

        /*保存用户*/
        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(password));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(password);
        userVo.setCompanyId(companyId);
        userVo.setIsFirst(1);
        userDaoImpl.create(userVo);

        /*保存公司*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setInvitationCompanyId(companyExtendVo.getId());
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());
        companyVo.setExamineStatus(0);
        companyVo.setStatus(0);
        companyDaoImpl.create(companyVo);

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(companyVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-","")
                .replace(":","")
                .replace(" ","");
        extendVo.setQrCode(qrCode);
        companyExtendDaoImpl.create(extendVo);

        return companyVo;
    }

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    public SaveCompanyResVo saveIndividual(RegisterIndividualReqVo reqVo) {

//        CompanyVo companyVo1 = new CompanyVo();
//        companyVo1.setContactPhone(reqVo.getContactPhone());
//        CompanyVo companyVo2 = companyDaoImpl.load(companyVo1,CompanyVo.class);
//        if (null != companyVo2 && !reqVo.getId().equals(companyVo2.getId())){
//            throw new CodeException("该号码已存在");
//        }
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getId());
        CompanyVo company = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        CompanyReqVo companyReqVo = new CompanyReqVo();
        ObjectHelper.writeWithFrom(companyReqVo,reqVo);
        companyReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());
        companyReqVo.setStatus(company.getStatus());
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("保存商户失败，请重试");
        }
        CompanyReqVo resCompanyReqVo = (CompanyReqVo) result.getData();

        /*更新公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,resCompanyReqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setExamineStatus(0);
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyDaoImpl.update(companyVo);
        System.out.println("companyAttribute:"+companyVo.getCompanyAttribute());

        /*跟新用户表添加联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userVo.setName(reqVo.getContactName());
        userDaoImpl.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setId(StringHelper.getNewID());
        req.setName(reqVo.getCompanyName());
        req.setAddress(reqVo.getAddress());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        req.setReqId(reqVo.getReqId());
        req.setPhone(reqVo.getContactPhone());
        req.setCreateTime(DateHelper.getNow());
        req.setProductCompanyName(reqVo.getCompanyName());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())){
            req.setId(StringHelper.getNewID());
        }else {
            req.setId(reqVo.getMerchantId());
        }


        SaveCompanyResVo resVo = new SaveCompanyResVo();
        ResponseResult result1 = storeFeign.merchantCreate(req);
        if (result1.getCode().equals("00")){
            String merchantId = (String) result1.getData();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyExtendId(companyVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     * @return 返回保存数据各表的主键
     */
    @Override
    public SaveCompanyResVo saveEnterprice(RegisterEnterpriceReqVo reqVo) {

//        CompanyVo companyVo1 = new CompanyVo();
//        companyVo1.setContactPhone(reqVo.getContactPhone());
//        CompanyVo companyVo2 = companyDaoImpl.load(companyVo1,CompanyVo.class);
//        if (null != companyVo2 && !reqVo.getId().equals(companyVo2.getId())){
//            throw new CodeException("该号码已存在");
//        }
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getId());
        CompanyVo company = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        CompanyReqVo companyReqVo = new CompanyReqVo();
        ObjectHelper.writeWithFrom(companyReqVo,reqVo);
        companyReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());
        companyReqVo.setStatus(company.getStatus());
        companyReqVo.setBankList(new ArrayList());
        CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
        ObjectHelper.writeWithFrom(companyBankReqVo,reqVo);
        companyBankReqVo.setId(StringHelper.getNewID());
        companyReqVo.getBankList().add(companyBankReqVo);
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("保存商户失败，请重试");
        }
        CompanyReqVo resCompanyReqVo = (CompanyReqVo) result.getData();

        /*更新公司表*/
        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo,resCompanyReqVo);
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setExamineStatus(0);
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        System.out.println("companyAttribute:"+companyVo.getCompanyAttribute());
        companyDaoImpl.update(companyVo);

        List<CompanyBankReqVo> bankList = resCompanyReqVo.getBankList();
        if (null == bankList || bankList.isEmpty()){
            throw new CodeException("保存商户失败，请重试");
        }

        /*保存银行卡，并将其设置为默认银行卡*/
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo,bankList.get(0));
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        companyBankCardVo.setPhone(reqVo.getContactPhone());
        companyBankCardVo.setType(reqVo.getCompanyType());
        companyBankCardVo.setName(reqVo.getContactName());
        companyBankCardVo.setIdCard(reqVo.getContactCode());
        companyBankCardVo.setCompanyId(reqVo.getId());
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setBankCardCode(companyBankCardVo.getBankCardCode());
        CompanyBankCardVo companyBankCardVo1 = companyBankCardDaoImpl.load(companyBankCardGetReqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVo1){
            companyBankCardDaoImpl.create(companyBankCardVo);
        }else {
            companyBankCardVo.setId(companyBankCardVo1.getId());
            companyBankCardDaoImpl.update(companyBankCardVo);
        }


        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(resCompanyReqVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-","")
                .replace(":","")
                .replace(" ","");
        extendVo.setQrCode(qrCode);
        companyExtendDaoImpl.save(extendVo);

        SaveCompanyResVo resVo = new SaveCompanyResVo();



        /*更新用户信息，保存联系方式*/
        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userVo.setName(reqVo.getContactName());
        userDaoImpl.update(userVo);

        /*保存或更新商户表*/
        MerchantCreateReqVo req=new MerchantCreateReqVo();
        req.setReqId(StringHelper.getNewID());
        req.setName(reqVo.getMerchantName());
        req.setType(reqVo.getCompanyAttribute());
        req.setProductCompanyId(reqVo.getId());
        req.setUserId(userVo.getId());
        req.setUsername(userVo.getAccount());
        if (null == reqVo.getMerchantId() || "".equals(reqVo.getMerchantId())){
            req.setId(StringHelper.getNewID());
        }else {
            req.setId(reqVo.getMerchantId());
        }
        if (null == reqVo.getMerchantAddress() || reqVo.getMerchantAddress().isEmpty()){
            req.setAddress(reqVo.getAddress());
        }else{
            req.setAddress(reqVo.getMerchantAddress());
        }

        ResponseResult result1 = storeFeign.merchantCreate(req);
        if (result1.getCode().equals("00")){
            String merchantId = (String) result1.getData();
            resVo.setMerchantId(merchantId);
        }

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyBankCardId(companyBankCardVo.getId());
        resVo.setCompanyExtendId(extendVo.getId());
        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @Override
    public LoginResVo login(LoginReqVo reqVo) throws Exception {
        String accountOrPhone = reqVo.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }
        if (userVo == null){
            throw new CodeException("用户名不存在");
        }

        /*通过私钥将rsa加密的密码解密*/
        String password = RSAUtils.decryptionByPrivateKey(reqVo.getPassword(),RsaConstant.privateKey);
        if (!(StringHelper.md5(password).equals(userVo.getPassword()))){
            throw new CodeException("用户名或密码错误");
        }
        String token = TokenUtil.createToken(reqVo.getAccountOrPhone());

        LoginResVo resVo = new LoginResVo();
        resVo.setToken(token);
        userVo.setPassword("");
        userVo.setRemark("");
        resVo.setUserVo(userVo);
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        LoginCompanyResVo loginCompanyResVo = new LoginCompanyResVo();
        loginCompanyResVo.setCompanyVo(companyVo);
        resVo.setCompanyResVo(loginCompanyResVo);
        reqVo.setToken(token);

        LoginTokenVo loginVo = new LoginTokenVo();
        loginVo.setToken(token);
        loginVo.setDataPwd(token);
        loginVo.setData(JsonHelper.serialize(reqVo));
        loginVo.setExpairTime(DateHelper.getNow());
        tokenService.save(loginVo);
        TokenHelper.write(token,loginVo);
        // TODO
        // LoginTokenVo longVo1 =  TokenHelper.get(false,LoginTokenVo.class);
        // System.out.println("loning=====" + JsonHelper.serialize(longVo1));
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(companyVo.getId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(getReqVo,CompanyBankCardVo.class);

        if (companyBankCardVoList != null && !companyBankCardVoList.isEmpty()){
            loginCompanyResVo.setBankCardVoList(companyBankCardVoList);
        }
        resVo.setCompanyResVo(loginCompanyResVo);

        /*获取商家信息*/
        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        companyScenicInfoReqVo.setReqId(StringHelper.getNewID());
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setProductOrInterface(0);
        ResponseResult result = new ResponseResult();
        try {
            result = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
        }catch (Exception e){
            resVo.setMerchant(null);
        }
        Merchant merchant = (Merchant) result.getData();
        resVo.setMerchant(merchant);

        /*判断基本信息是否完善，及状态是否为2，且为个人用户，若不完善则跳转个人完善页面*/
        if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && CompanyConstant.COMPANY_TYPE_PERSON==(companyVo.getCompanyType())){
            resVo.setCode("01");
            resVo.setMsg("个人基本信息未完善，跳转个人完善页面");
            return resVo;
        }
        /*判断基本信息是否完善，及状态是否为2，且为公司用户，若不完善则跳转个人完善页面*/
        else if (companyVo.getStatus() < (CompanyConstant.COMPANY_STATUS_BIND_PHONE) && (CompanyConstant.COMPANY_TYPE_COMPANY==(companyVo.getCompanyType()))){
            resVo.setCode("02");
            resVo.setMsg("公司基本信息未完善，跳转公司完善页面");
            return resVo;
        }
        /*判断电子签约状态，若不等于1，则跳转签约页面*/
        /*else if (companyVo.getSigningStatus() != CompanyConstant.COMPANY_STATUS_SIGN_success){
            CompanyReqVo companyReqVo = new CompanyReqVo();
            companyReqVo.setId(companyVo.getId());
            ResponseResult result1 = new ResponseResult();
            try {
                result1 = payFeign.sign(companyReqVo);
            }catch (Exception e){
                e.printStackTrace();
                throw new CodeException("跳转签约页面失败，请重试");
            }
            CompanyReqVo companyReqVo1 = (CompanyReqVo) result1.getData();
            resVo.setCode("04");
            resVo.setMsg("未签约，跳转签约页面");
            resVo.setUrl(companyReqVo1.getSignUrl());
            return resVo;
        }*/

        if (companyBankCardVoList == null || companyBankCardVoList.isEmpty()){
            /*该公司没有银行卡，需要跳转添加银行卡*/
            resVo.setCode("03");
            resVo.setMsg("还未添加银行卡，跳转添加银行卡页面");
            return resVo;
        }
        /*获取用户权限列表*/
        UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
        userRoleGetReqVo.setUserId(userVo.getId());
        List<UserRoleVo> userRoleVoList = userRoleDaoImpl.loadList(userRoleGetReqVo,UserRoleVo.class);
        if (null != userRoleVoList && !userRoleVoList.isEmpty()){
            List<String> roleIdList = new ArrayList();
            for (UserRoleVo userRoleVo:userRoleVoList) {
                roleIdList.add(userRoleVo.getRoleId());
            }
            Set authorityIdSet = new HashSet();

            for (String roleId:roleIdList) {
                RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
                roleAuthorityGetReqVo.setRoleId(roleId);
                List<RoleAuthorityVo> roleAuthorityVoList = roleAuthorityDaoImpl.loadList(roleAuthorityGetReqVo,RoleAuthorityVo.class);
                if (roleAuthorityVoList != null && !roleAuthorityVoList.isEmpty()){
                    for (RoleAuthorityVo roleAuthorityVo:roleAuthorityVoList) {
                        authorityIdSet.add(roleAuthorityVo.getAuthorityId());
                    }
                }
            }
            List<String> authorityIdList = new ArrayList();
            Object[] objs = authorityIdSet.toArray();
            for (Object obj:objs) {
                authorityIdList.add((String) obj);
            }
            List<AuthorityVo> levelOneList = new ArrayList();
            for (int i = 0; i < authorityIdList.size(); i++) {
                AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
                authorityGetReqVo.setId(authorityIdList.get(i));
                AuthorityVo authorityVo = authorityDaoImpl.load(authorityGetReqVo,AuthorityVo.class);
                if (!StringHelper.isEmpty(authorityVo) && StringHelper.isEmpty(authorityVo.getPid())){
                    levelOneList.add(authorityVo);
                    authorityIdList.set(i,"");
                }
            }
            List<String> authorityIds = new ArrayList<>();
            for (int i = 0; i < authorityIdList.size(); i++) {
                if (!"".equals(authorityIdList.get(i))){
                    authorityIds.add(authorityIdList.get(i));
                }
            }
            Collections.sort(levelOneList);
            if (null == levelOneList || levelOneList.isEmpty()){
                throw new CodeException("该用户暂无权限，请添加");
            }
            List<AuthorityListByLevelResVo> authorityListByLevel = new ArrayList<>();
            for (AuthorityVo authorityVo:levelOneList) {
                AuthorityListByLevelResVo resVo1 = new AuthorityListByLevelResVo();
                ObjectHelper.writeWithFrom(resVo1,authorityVo);
                List<AuthorityListByLevelResVo> childList = getChildList(authorityVo,authorityIds);
                resVo1.setChildList(childList);
                authorityListByLevel.add(resVo1);
            }
            Collections.sort(authorityListByLevel);
            resVo.setAuthorityListByLevel(authorityListByLevel);
        }

        resVo.setCode("00");
        System.out.println(JsonHelper.serialize(resVo));
        return resVo;
    }

    public List<AuthorityListByLevelResVo> getChildList(AuthorityVo authorityVo,List<String> authorityIds){
        List<AuthorityListByLevelResVo> resVoList = new ArrayList<>();
        for (int i = 0;i<authorityIds.size();i++) {
            AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
            authorityGetReqVo.setId(authorityIds.get(i));
            AuthorityVo authorityVo1 = authorityDaoImpl.load(authorityGetReqVo,AuthorityVo.class);
            if(!StringHelper.isEmpty(authorityVo1)){
                if (authorityVo1.getPid().equals(authorityVo.getId())){
                    List<String> authorityIdList = new ArrayList<>();
                    authorityIdList.addAll(authorityIds);
                    authorityIdList.remove(i);
                    AuthorityListByLevelResVo resVo = new AuthorityListByLevelResVo();
                    ObjectHelper.writeWithFrom(resVo,authorityVo1);
                    if (authorityIds.size()>0){
                        resVo.setChildList(getChildList(authorityVo1,authorityIdList));
                    }
                    resVoList.add(resVo);
                }
            }else{
                System.out.println("无该权限：" + authorityIds.get(i));
            }

        }
        Collections.sort(resVoList);
        return resVoList;
    }

    @Override
    public LoginResVo verifyLogin(ComputerLoginReqVo reqVo, HttpSession session, HttpServletRequest request) throws Exception {
        verifyCodeServiceImpl.validImage(reqVo.getVerifyCode(),session,request);
        LoginReqVo reqVo1 = new LoginReqVo();
        ObjectHelper.writeWithFrom(reqVo1,reqVo);
        return this.login(reqVo1);
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String individualSubmit(IndividualSubmitReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyVo companyVo = companyDaoImpl.load(getReqVo,CompanyVo.class);
        /*此处应该将companyVo和verifyCode发送到第三方接口，返回的数据用于更新公司信息*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        ObjectHelper.writeWithFrom(companyReqVo,companyVo);
        companyReqVo.setValidateCode(reqVo.getVerifyCode());
        companyReqVo.setCompanyAttribution(companyVo.getCompanyAttribute());
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("保存商户失败，请重试");
        }
        CompanyReqVo resCompanyReqVo = (CompanyReqVo) result.getData();

        /*更新公司表*/
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1,resCompanyReqVo);
        companyVo1.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo1.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyVo1.setExamineStatus(0);
        companyDaoImpl.update(companyVo1);
        return reqVo.getVerifyCode();
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    public String enterpriceSubmit(EnterpriceSubmitReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyVo companyVo = companyDaoImpl.load(getReqVo,CompanyVo.class);
        /*此处应该调用第三方接口传入companyVo发送手机验证码并更新公司状态*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        ObjectHelper.writeWithFrom(companyReqVo,companyVo);
        companyReqVo.setValidateCode(reqVo.getVerifyCode());
        companyReqVo.setCompanyAttribution(companyVo.getCompanyAttribute());
        CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
        ObjectHelper.writeWithFrom(companyBankReqVo,reqVo);
        companyBankReqVo.setType(reqVo.getCompanyType());
        companyBankReqVo.setCompanyId(reqVo.getId());
        companyBankReqVo.setName(reqVo.getContactName());
        companyBankReqVo.setIdCard(reqVo.getContactCode());
        companyBankReqVo.setPhone(reqVo.getContactPhone());
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setBankCardCode(reqVo.getBankCardCode());
        CompanyBankCardVo companyBankCardVo1 = companyBankCardDaoImpl.load(companyBankCardGetReqVo,CompanyBankCardVo.class);
        companyBankReqVo.setStatus(companyBankCardVo1.getStatus());
        companyBankReqVo.setId(StringHelper.getNewID());
        companyBankReqVo.setValidateCode(reqVo.getVerifyCode());
        companyReqVo.setBankList(new ArrayList<>());
        companyReqVo.getBankList().add(companyBankReqVo);

        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("保存商户失败，请重试");
        }
        CompanyReqVo resCompanyReqVo = (CompanyReqVo) result.getData();

        /*更新公司表*/
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1,resCompanyReqVo);
        companyVo1.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo1.setExamineStatus(0);
        companyVo1.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyDaoImpl.update(companyVo1);

        List<CompanyBankReqVo> bankList = resCompanyReqVo.getBankList();
        if (null == bankList || bankList.isEmpty()){
            throw new CodeException("保存商户失败，请重试");
        }

        /*保存银行卡，并将其设置为默认银行卡*/
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo,bankList.get(0));
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        if (6 == companyReqVo.getStatus()){
            companyBankCardVo.setStatus(1);
            companyBankCardVo.setBindingTime(
                    DateHelper.getNow()
                            .substring(0,10)
                            .replace("-",""));
        }
        companyBankCardVo.setType(resCompanyReqVo.getCompanyType());
        companyBankCardVo.setCompanyId(resCompanyReqVo.getId());
        companyBankCardVo.setName(resCompanyReqVo.getContactName());
        companyBankCardVo.setIdCard(resCompanyReqVo.getContactCode());
        companyBankCardVo.setPhone(resCompanyReqVo.getContactPhone());
        CompanyBankCardGetReqVo companyBankCardGetReqVo1 = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo1.setBankCardCode(bankList.get(0).getBankCardCode());
        CompanyBankCardVo companyBankCardVo2 = companyBankCardDaoImpl.load(companyBankCardGetReqVo1,CompanyBankCardVo.class);
        if (null == companyBankCardVo2){
            companyBankCardDaoImpl.create(companyBankCardVo);
        }else {
            companyBankCardVo.setId(companyBankCardVo2.getId());
            companyBankCardDaoImpl.update(companyBankCardVo);
        }
        return reqVo.getVerifyCode();
    }

    @Override
    public String fileUpload(CommonsMultipartFile file) throws IOException {
        String path = "C:/" + DateHelper.getNow() + file.getOriginalFilename();
        File newFile = new File(path);
        file.transferTo(newFile);
        return path;
    }

    @Override
    public void businesslicenseCode(BusinessLicenseCodeReqVo reqVo) {
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        if (null == companyVo){
            throw new CodeException("未查询到该公司信息，请稍后重试");
        }
        companyVo.setUrl(reqVo.getUrl());
        companyDaoImpl.update(companyVo);
    }
}
