package com.tcm.common.service.impl;

import com.tcm.common.dao.CompanyDao;
import com.tcm.common.service.CompanyService;
import com.tcm.common.service.ImageService;
import com.tcm.util.common.CompanyVo;
import com.tcm.util.common.req.CompanyLoadPageReqVo;
import com.tcm.util.common.req.CompanyReqVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.CompanyResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class CompanyServiceImpl implements CompanyService {

    private final CompanyDao companyDao;
    private final ImageService imageService;

    public CompanyServiceImpl(CompanyDao companyDao, ImageService imageService) {
        this.companyDao = companyDao;
        this.imageService = imageService;
    }


    @Override
    public String save(CompanyReqVo req) {
        if (StringHelper.isEmpty(req.getCompanyId())) {
            CompanyVo company = new CompanyVo();
            String companyId = StringHelper.getNewID();
            company.setCompanyId(companyId);
            ObjectHelper.writeWithFrom(company, req);
            companyDao.save(company);
            return companyId;
        } else {
            CompanyVo company = new CompanyVo();
            company.setCompanyId(req.getCompanyId());
            CompanyVo load = companyDao.load(company, CompanyVo.class);
            ObjectHelper.writeWithFrom(load, req);
            companyDao.update(load);
            return req.getCompanyId();
        }
    }

    @Override
    public CompanyResVo load(CompanyReqVo req) {
        CompanyVo company = new CompanyVo();
        company.setCompanyId(req.getCompanyId());
        company.setCompanyStatus(req.getCompanyStatus() == null ? 0 : req.getCompanyStatus());
        CompanyResVo load = companyDao.load(company, CompanyResVo.class);
        // 图片加载
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(load.getCompanyId());
        load.setCompanyImageList(imageService.loadList(imageReqVo));
        return load;
    }

    @Override
    public PageSizeData<CompanyResVo> loadPage(CompanyLoadPageReqVo req) {
        PageSizeData<CompanyResVo> page = companyDao.loadPage(req, CompanyResVo.class);
        return page;
    }

    @Override
    public String remove(CompanyReqVo req) {
        CompanyVo company = new CompanyVo();
        company.setCompanyId(req.getCompanyId());
        companyDao.remove(company);

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getCompanyId());
        imageService.remove(imageReqVo);
        return req.getCompanyId();
    }
}
