package com.tcm.doctor.service.impl;

import com.tcm.doctor.dao.DoctorScheduleDao;
import com.tcm.doctor.service.DoctorScheduleService;
import com.tcm.util.doctor.DoctorScheduleVo;
import com.tcm.util.doctor.req.DoctorLoadPageReqVo;
import com.tcm.util.doctor.req.DoctorScheduleReqVo;
import com.tcm.util.doctor.res.DoctorScheduleResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DoctorScheduleServiceImpl implements DoctorScheduleService {


    private final DoctorScheduleDao doctorScheduleDao;

    public DoctorScheduleServiceImpl(DoctorScheduleDao doctorScheduleDao) {
        this.doctorScheduleDao = doctorScheduleDao;
    }


    @Override
    public String save(DoctorScheduleReqVo req) {

        List<DoctorScheduleVo> saveList = new ArrayList<>();
        for (DoctorScheduleVo doctorScheduleVo : req.getScheduleVoList()) {
            DoctorScheduleVo scheduleVo = new DoctorScheduleVo();
            scheduleVo.setScheduleId(StringHelper.getNewID());
            ObjectHelper.writeWithFrom(scheduleVo, doctorScheduleVo);
            saveList.add(scheduleVo);
        }
        doctorScheduleDao.createList(saveList);
        return req.getDoctorId();
    }

    @Override
    public List<DoctorScheduleResVo> load(DoctorScheduleReqVo req) {
        DoctorScheduleVo scheduleVo = new DoctorScheduleVo();
        scheduleVo.setDoctorId(req.getDoctorId());
        List<DoctorScheduleResVo> loadList = doctorScheduleDao.loadList(scheduleVo, DoctorScheduleResVo.class);
        return loadList;
    }

    @Override
    public PageSizeData<DoctorScheduleResVo> loadPage(DoctorLoadPageReqVo req) {
        PageSizeData<DoctorScheduleResVo> page = doctorScheduleDao.loadPage(req, DoctorScheduleResVo.class);
        return page;
    }


    @Override
    public String remove(DoctorScheduleReqVo req) {
        DoctorScheduleVo scheduleVo = new DoctorScheduleVo();
        scheduleVo.setScheduleId(req.getScheduleId());
        DoctorScheduleVo load = doctorScheduleDao.load(scheduleVo, DoctorScheduleVo.class);
        doctorScheduleDao.remove(load);
        return req.getScheduleId();
    }
}
