package com.tcm.product.dao.impl;

import com.tcm.product.dao.ProductDao;
import com.tcm.util.product.ProductVo;
import com.tcm.util.product.req.ProductLoadPageReqVo;
import com.tcm.util.product.req.ProductReqVo;
import com.tcm.util.product.res.ProductResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ProductDaoImpl extends BaseDaoImpl implements ProductDao {

    private static final String SQL_PRODUCT_LOAD_INFO = "product_load_info";
    private static final String SQL_PRODUCT_LOAD_BY_PAGE = "product_load_by_page";

    @Override
    protected void init() {
        register(ProductVo.class);
        table.add(SQL_PRODUCT_LOAD_INFO, "select p.* from tcm_product as p where 1=1 {WHERE} order by p.sort")
                .add("productId", " AND p.product_id = ?")
                .add("categoryId", " AND p.category_id =?")
        ;
        table.add(SQL_PRODUCT_LOAD_BY_PAGE, "select p.* from tcm_product as p" +
                " left join tcm_product_extend as pe on p.product_id = pe.product_id where 1=1 {WHERE} order by p.sort")
                .add("productId", " AND p.product_id = ?")
                .add("categoryId", " AND p.category_id =?")
                .add("productName", " AND pe.product_name like concat('%',?,'%')")
                .add("productType", " AND p.product_type =?")
                .add("status", " AND p.status =?")
                .add("position", " AND pe.position =?")
                .add("categoryType", " AND p.category_type =?")
                .add("languageType", "and pe.language_type =?")
        ;
    }

    @Override
    public List<ProductResVo> loadInfoList(ProductReqVo req) {
        return query(ProductResVo.class, SQL_PRODUCT_LOAD_INFO, req);
    }

    @Override
    public PageSizeData<ProductResVo> loadByPage(ProductLoadPageReqVo req) {
        return this.queryPage(ProductResVo.class, req, SQL_PRODUCT_LOAD_BY_PAGE, req);
    }
}
