package com.tcm.system.user.web;

import com.tcm.system.user.service.UserService;
import com.tcm.system.user.vo.req.TcmUserPageReqVo;
import com.tcm.system.user.vo.req.TcmUserReqVo;
import com.tcm.system.user.vo.req.TcmUserSaveReqVo;
import com.tcm.system.user.vo.res.TcmUserResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value="/user")
@Api(value = "用户类")
public class TcmUserController {

    private UserService userService;

    public TcmUserController(UserService userService) {
        this.userService = userService;
    }

    /**
     * 分页查询员工信息
     * @param req
     * @return
     */
    @ApiOperation(value ="分页查询员工信息", notes = "返回员工信息列表")
    @RequestMapping(value = "/findUserPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<TcmUserResVo>> findUserPage(@RequestBody TcmUserPageReqVo req) {
        return ResponseResult.result(userService.findUserPage(req));
    }

    @ApiOperation(value ="查询员工信息列表", notes = "返回员工信息列表")
    @RequestMapping(value = "/findUserList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<List<TcmUserResVo>> findUserList(@RequestBody TcmUserReqVo req) {
        return ResponseResult.result(userService.findUserList(req));
    }

    @ApiOperation(value ="查询员工信息", notes = "返回员工信息")
    @RequestMapping(value = "/findUserInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<TcmUserResVo> findUserInfo(@RequestBody TcmUserReqVo req) {
        return ResponseResult.result(userService.findUserInfo(req));
    }

    @ApiOperation(value ="保存员工信息", notes = "返回成功失败")
    @RequestMapping(value = "/saveUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveUser(@RequestBody TcmUserSaveReqVo req) {
        return ResponseResult.result(userService.saveUser(req));
    }

    @ApiOperation(value ="删除员工信息", notes = "返回成功失败")
    @RequestMapping(value = "/delUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> delUser(@RequestBody TcmUserSaveReqVo req) {
        userService.delUser(req);
        return ResponseResult.result("删除成功");
    }
}
