package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.vo.reqvo.RoleAuthorityGetReqVo;
import com.pangding.web.authority.vo.RoleAuthorityVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleAuthorityDaoImpl extends BaseDaoImpl implements RoleAuthorityDao {

    private static final String SELECT = "SELECT";

    @Override
    protected void init() {

        register(RoleAuthorityVo.class);

        table.add(SELECT,"select id,role_id,authority_id from pd_role_authority where 1=1 ")
                .add("roleId","and role_id = ?")
                .add("authorityId","and authority_id = ?");

    }

    @Override
    public List<RoleAuthorityVo> getRoleAuthorityList(RoleAuthorityGetReqVo roleAuthorityGetReqVo) {
        return this.query(RoleAuthorityVo.class,SELECT, roleAuthorityGetReqVo);
    }
}
