package com.tcm.common.web;

import com.tcm.common.service.CompanyService;
import com.tcm.util.common.req.CompanyLoadPageReqVo;
import com.tcm.util.common.req.CompanyReqVo;
import com.tcm.util.common.res.CompanyResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/company")
public class CompanyController {

    private final CompanyService companyService;

    public CompanyController(CompanyService companyService) {
        this.companyService = companyService;
    }

    /**
     * 公司新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(companyService.save(req));

    }

    /**
     * 公司加载
     */
    @RequestMapping("/load")
    public ResponseResult<CompanyResVo> load(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(companyService.load(req));
    }

    /**
     * 公司分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<CompanyResVo>> loadPage(@RequestBody CompanyLoadPageReqVo req) {
        return ResponseResult.result(companyService.loadPage(req));

    }

    /**
     * 公司删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(companyService.remove(req));
    }

}
