package com.tcm.util.product;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_product_price")
public class ProductPriceVo {

    /**
     * 价格主键id
     */
    @TableAnnotation("price_id")
    @ApiModelProperty(notes = "价格主键id")
    private String priceId;
    /**
     * 产品id
     */
    @TableAnnotation("product_id")
    @ApiModelProperty(notes = "产品id")
    private String productId;
    /**
     * 价格类型
     */
    @TableAnnotation("price_type")
    @ApiModelProperty(notes = "价格类型")
    private Integer priceType;
    /**
     * 开始时间
     */
    @TableAnnotation("start_date")
    @ApiModelProperty(notes = "开始时间")
    private String startDate;
    /**
     * 结束时间
     */
    @TableAnnotation("end_date")
    @ApiModelProperty(notes = "结束时间")
    private String endDate;
    /**
     * 价格
     */
    @TableAnnotation("price")
    @ApiModelProperty(notes = "价格")
    private Double price;
    /**
     * 市场价
     */
    @TableAnnotation("market_price")
    @ApiModelProperty(notes = "市场价")
    private Double marketPrice;
    /**
     * 结算价
     */
    @TableAnnotation("settlement_price")
    @ApiModelProperty(notes = "结算价")
    private Double settlementPrice;
    /**
     * 价格状态0上架1下架
     */
    @TableAnnotation("price_status")
    @ApiModelProperty(notes = "价格状态0上架1下架")
    private Integer priceStatus;
    /**
     * 备注
     */
    @TableAnnotation("remark")
    @ApiModelProperty(notes = "备注")
    private String remark;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public ProductPriceVo() {
    }

    public String getPriceId() {
        return priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Double marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Double getSettlementPrice() {
        return settlementPrice;
    }

    public void setSettlementPrice(Double settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    public Integer getPriceStatus() {
        return priceStatus;
    }

    public void setPriceStatus(Integer priceStatus) {
        this.priceStatus = priceStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
