package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.resvo.SaveCompanyResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.helper.FileHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/5/14 16:28
 */

@RestController
@RequestMapping(value="/computerRegister")
public class ComputerRegisterController {
    @Autowired
    RegisterService registerServiceImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    private CompanyService companyServiceImpl;

    /**
     * 验证注册第一页数据的合法性并保存在pd_user表中
     * 生成公司id，pd_company表中存入一条数据
     * 返回公司部分信息（id,invitationCompanyId,companyType），携带到基本信息页面
     *
     * @param registerUserReqVo
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> saveUser(@RequestBody RegisterUserReqVo registerUserReqVo) throws Exception {
        CheckerHelper.newInstance()
                .notBlankCheck("account",registerUserReqVo.getAccount())
                .notBlankCheck("password",registerUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",registerUserReqVo.getConfirmPassword())
                .notBlankCheck("companyType",registerUserReqVo.getCompanyType())
                .notBlankCheck("invitationCode",registerUserReqVo.getInvitationCode())
                .checkException();
        return ResponseResult.result(registerServiceImpl.saveUser(registerUserReqVo));
    }

    /**
     * 当用户类型选择为“个体”时进入此方法
     * 验证注册第二页数据的合法性并保存，pd_company,pd_company_bank_card,pd_company_extend,pd_merchant都增加一条数据
     * 并将联系电话更新到pd_user表中
     * 返回pd_user,pd_company,pd_company_bank_card,pd_company_extend,pd_merchant表的主键
     *
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/individual", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<SaveCompanyResVo> saveIndividual(@RequestBody RegisterIndividualReqVo reqVo){
        checkIndividual(reqVo);
        return ResponseResult.result(registerServiceImpl.saveIndividual(reqVo));
    }

    private void checkIndividual(RegisterIndividualReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .checkPhoneNo("contactPhone",reqVo.getContactPhone())
                .checkException();
    }

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @RequestMapping(value="/individualSubmit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> individualSubmit(@RequestBody IndividualSubmitReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .notBlankCheck("verifyCode",reqVo.getVerifyCode())
                .checkException();
        String verifyCode = registerServiceImpl.individualSubmit(reqVo);
        return ResponseResult.result(verifyCode);
    }

    /**
     * 当用户类型选择为“企业”时进入此方法
     * 验证注册第二页数据的合法性并保存，pd_company,pd_company_bank_card,pd_company_extend,pd_merchant都增加一条数据
     * 并将联系电话更新到pd_user表中
     * 返回pd_user,pd_company,pd_company_bank_card,pd_company_extend,pd_merchant表的主键
     * @param reqVo
     * @return
     */
    @RequestMapping(value="/enterprise", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<SaveCompanyResVo> saveEnterprise(@RequestBody RegisterEnterpriceReqVo reqVo){
        checkEnterprice(reqVo);
        return ResponseResult.result(registerServiceImpl.saveEnterprice(reqVo));
    }

    private void checkEnterprice(RegisterEnterpriceReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyName",reqVo.getCompanyName())
                .notBlankCheck("companyAddress",reqVo.getAddress())
                .notBlankCheck("businessLicenseCode",reqVo.getBusinessLicenseCode())
                .notBlankCheck("merchantName",reqVo.getMerchantName())
                .notBlankCheck("companyAttribute",reqVo.getCompanyAttribute())
                .notBlankCheck("contactName",reqVo.getContactName())
                .notBlankCheck("contactCode",reqVo.getContactCode())
                .checkIdCard("contactCode",reqVo.getContactCode())
                .notBlankCheck("contactPhone",reqVo.getContactPhone())
                .notBlankCheck("bankName",reqVo.getBankName())
                .notBlankCheck("bankCardCode",reqVo.getBankCardCode())
                .notNumberCheck("bankCardCode",reqVo.getBankCardCode())
                .notBlankCheck("bankAddress",reqVo.getBankAddress())
                .notBlankCheck("bankCode",reqVo.getBankCode())
                .notNumberCheck("bankCode",reqVo.getBankCode())
                .checkException();
    };

    /**
     * 将通过公司id获取到的公司信息和验证码传到第三方，并将返回的信息用于更新公司状态
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @RequestMapping(value="/enterpriceSubmit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> enterpriceSubmit(@RequestBody EnterpriceSubmitReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .notBlankCheck("verifyCode",reqVo.getVerifyCode())
                .checkException();
        String verifyCode = registerServiceImpl.enterpriceSubmit(reqVo);
        return ResponseResult.result(verifyCode);
    }

    /**
     * 上传印业执照图片地址，更新公司表
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/businessLicenseCode",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult businessLicenseCode(@RequestBody BusinessLicenseCodeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .notBlankCheck("url",reqVo.getUrl())
                .checkException();
        registerServiceImpl.businesslicenseCode(reqVo);
        return new ResponseResult();
    }

    @RequestMapping(value = "/fileUpload",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> fileUpload(@RequestBody CommonsMultipartFile file) throws IOException {
        return ResponseResult.result(registerServiceImpl.fileUpload(file));
    }


    /**
     * 检查邀请码是否真实存在
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/checkInvitationCode",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<CompanyVo> checkInvitationCode(@RequestBody CheckInvitationCodeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("invitationCode",reqVo.getInvitationCode())
                .checkException();
        return ResponseResult.result(companyServiceImpl.checkInvitationCode(reqVo));
    }
}
