package com.pangding.web.authority.controller.company;


import com.pangding.web.authority.service.CompanyAgreementService;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.company.NewCompanyService;
import com.pangding.web.vo.system.pd.company.CompanyAgreementVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.req.company.SaveCompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyPageResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/newCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CompanyController {

    @Autowired
    private NewCompanyService newCompanyService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private CompanyAgreementService companyAgreementService;

    @RequestMapping(value = "/findCompanyListPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "分页查询公司列表", notes = "返回公司列表，按页数")
    public ResponseResult<CompanyPageResVo> findCompanyListPage(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(newCompanyService.findCompanyListPage(req));
    }

    @RequestMapping(value = "/findCompanyList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询公司列表", notes = "返回所有的公司列表")
    public ResponseResult<List<CompanyResVo>> findCompanyList(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(newCompanyService.findCompanyList(req));
    }

    @RequestMapping(value = "/findCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询公司信息", notes = "返回公司详细信息")
    public ResponseResult<CompanyResVo> findCompany(@RequestBody CompanyReqVo req) {
        return ResponseResult.result(newCompanyService.findCompany(req));
    }

    @RequestMapping(value = "/updateCompanyInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "公司，个人实名制", notes = "返回实名制结果")
    public ResponseResult<SaveCompanyReqVo> updateCompanyInfo(@RequestBody SaveCompanyReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("id", req.getCompanyVo().getId()).checkException();
        return companyService.updateCompanyInfo(req);
    }

//    @RequestMapping(value = "/examineCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
//    @ApiOperation(value = "审核配置公司信息", notes = "返回审核配置的结果")
//    public ResponseResult<SaveCompanyReqVo> examineCompany(@RequestBody SaveCompanyReqVo req) {
//        CheckerHelper.newInstance().notBlankCheck("id", req.getCompanyVo().getId()).checkException();
//        return companyService.updateCompanyInfo(req);
//    }

//    @RequestMapping(value = "/examineCompany", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
//    @ApiOperation(value = "审核配置公司信息", notes = "返回审核配置的结果")
//    public ResponseResult<SaveCompanyReqVo> examineCompany(@RequestBody SaveCompanyReqVo req) {
//        CheckerHelper.newInstance().notBlankCheck("id", req.getCompanyVo().getId()).checkException();
//        return companyService.updateCompanyInfo(req);
//    }

    /**
     * 找到公司余额
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/findCompanyBalance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult findCompanyBalance(@RequestBody CompanyReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("id", req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyBalance(req));
    }

    @RequestMapping(value = "/findCompanyAgreement")
    @ApiOperation(value = "查询某合同详情", notes = "返回合同信息")
    public ResponseResult<CompanyAgreementVo> findCompanyAgreement(@RequestBody CompanyAgreementReqVo req) {
        CheckerHelper.newInstance()
//                .notBlankCheck("companyId", req.getCompanyId())
//                .notBlankCheck("agreementId", req.getAgreementId())
                .notBlankCheck("companyAgreementId", req.getCompanyAgreementId())
                .checkException();
        return ResponseResult.result(companyAgreementService.findCompanyAgreement(req));
    }

    @RequestMapping(value = "/findCompanyAgreementList")
    @ApiOperation(value = "查询公司签署的合同列表", notes = "返回合同信息")
    public ResponseResult<PageSizeData<CompanyAgreementVo>> findCompanyAgreementList(@RequestBody CompanyAgreementReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        return ResponseResult.result(companyAgreementService.findCompanyAgreementList(req));
    }

    @RequestMapping(value = "saveComapnyAgreement")
    @ApiOperation(value = "公司签署合同", notes = "返回签署结果")
    public ResponseResult saveCompanyAgreement(@RequestBody CompanyAgreementReqVo req){
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("agreementId", req.getAgreementId())
                .notBlankCheck("agreementCode", req.getAgreementCode())
                .checkException();
        return ResponseResult.result(companyAgreementService.saveCompanyAgreement(req));

    }

    @RequestMapping(value = "findCompanyById")
    @ApiOperation(value = "找到公司信息", notes = "找到公司信息")
    public ResponseResult<CompanyResVo> findCompanyById(@RequestBody CompanyReqVo req){
        CheckerHelper.newInstance().notBlankCheck("id", req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyById(req));
    }

    @RequestMapping(value = "synCompany")
    @ApiOperation(value = "找到公司信息", notes = "找到公司信息")
    public ResponseResult<String> synCompany(@RequestBody CompanyReqVo req){
        return companyService.synCompanyInfo(req);
    }

    @RequestMapping(value = "findInvitationReward")
    @ApiOperation(value = "找到公司邀请奖励信息", notes = "找到公司邀请奖励信息")
    public ResponseResult<CompanyResVo> findInvitationReward(@RequestBody CompanyReqVo req){
        CheckerHelper.newInstance().notBlankCheck("id", req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyInvitationReward(req));
    }
    @RequestMapping(value = "/findAllCompany")
    @ApiOperation(value = "查询所有公司", notes = "查询所有公司")
    public ResponseResult<List<CompanyVo>> findAllCompany(@RequestBody CompanyReqVo req){
        CheckerHelper.newInstance()
                .checkException();
        return ResponseResult.result(companyService.findAllCompany(req));
    }

}
