package com.pangding.web.authority.service.company;

import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.res.company.CompanyBankCardResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;

import java.util.List;

public interface CompanyBankCardService {

    /**
     * 分页查询银行卡列表
     * @param req
     * @return
     */
    PageSizeData<CompanyBankCardResVo> findCompanyBankCardListPage(CompanyBankCardReqVo req);

    /**
     * 查询银行卡列表
     * @param req
     * @return
     */
    List<CompanyBankCardResVo> findCompanyBankCardList(CompanyBankCardReqVo req);

    /**
     * 保存银行卡
     * @param reqVo
     * @return
     */
    ResponseResult<CompanyBankCardVo> saveBank(CompanyBankCardReqVo reqVo);

    /**
     * 删除银行卡（通联解绑银行卡）
     * @param req
     */
    void deleteBank(CompanyBankCardReqVo req);

    /**
     * 设计默认银行卡
     * @param req
     */
    void setDefaultBankCard(CompanyBankCardReqVo req);

}
