package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyMsgDao;
import com.pangding.web.authority.dao.DeviceDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.authority.mq.CompanyConsumer;
import com.pangding.web.authority.service.CompanyMsgService;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.partner.mq.PartnerProcedure;
import com.pangding.web.partner.vo.req.SoundContentVo;
import com.pangding.web.vo.order.tl.SoundContentInfoVo;
import com.pangding.web.vo.order.tl.SoundContentReqVo;
import com.pangding.web.vo.order.tl.SoundReqVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.pangding.web.vo.system.res.authority.UserResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import static com.yanzuoguang.util.helper.DateHelper.getCurDate;


@Service
public class CompanyMsgServiceImpl implements CompanyMsgService {

    @Autowired
    private CompanyDao companyDao;

    @Autowired
    private CompanyMsgDao companyMsgDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private PartnerProcedure partnerProcedure;
    @Autowired
    private CompanyConsumer companyConsumer;


    @Override
    public PageSizeData<CompanyMsgResVo> findCompanyMsgList(CompanyMsgReqVo req) {
        return companyMsgDao.findPageCompanyMsgList(req);
    }

    @Override
    public ResponseResult saveCompanyMsg(CompanyMsgReqVo reqVo) {

        companyMsgDao.create(reqVo);

        DeviceReqVo deviceReqVo = new DeviceReqVo();
        deviceReqVo.setCompanyId(reqVo.getCompanyId());
        deviceReqVo.setDeviceType(CompanyConstant.DEVICE_SOUND);
        deviceReqVo.setTollPoint(reqVo.getExtendInfo());
        DeviceResVo deviceResVo = deviceDao.load(deviceReqVo, DeviceResVo.class);
        System.out.println("请求参数：" + JsonHelper.serialize(deviceReqVo) + ",查询结果：" + JsonHelper.serialize(deviceResVo));
        if (!StringHelper.isEmpty(deviceResVo)) {
            String deviceCode = deviceResVo.getDeviceCode();
            String deviceName = deviceResVo.getDeviceName();
            SoundContentInfoVo soundContentInfoVo = new SoundContentInfoVo();
            soundContentInfoVo.setMsg_content(reqVo.getMsgContent());
            soundContentInfoVo.setMsg_id(reqVo.getId());
            soundContentInfoVo.setVoice_speed("50");
            SoundContentReqVo soundContentReqVo = new SoundContentReqVo();
            soundContentReqVo.setInfo(soundContentInfoVo);
            soundContentReqVo.setType("audio");

            SoundReqVo soundReqVo = new SoundReqVo();
            soundReqVo.setContent(soundContentReqVo);
            soundReqVo.setProKey(deviceCode);
            soundReqVo.setTopicName("/" + deviceCode + "/" + deviceName + "/user/report");
            companyConsumer.sendSound(soundReqVo);
        }

        SoundContentVo soundContentVo = new SoundContentVo();
        soundContentVo.setTipContent(reqVo.getMsgContent());
        soundContentVo.setTipSound(reqVo.getMsgSound());
        soundContentVo.setTipUrl("http://frapp.pangdly.com?msg=" + soundContentVo.getTipContent());

        UserReqVo userReqVo = new UserReqVo();
        userReqVo.setCompanyId(reqVo.getCompanyId());
        userReqVo.setReceiveFlag(1);
        List<UserResVo> userResList = userDao.loadList(userReqVo, UserResVo.class);

        for (int i = 0; i < userResList.size(); i++) {
            if (1 == userResList.get(i).getReceiveFlag()) {
                partnerProcedure.sendSoundContent(userResList.get(i).getId(), soundContentVo);
            }
        }
        return ResponseResult.result("处理成功");
    }



    public void checkCompanyExpirationDate(CompanyReqVo req){
        CompanyResVo companyResVo = companyDao.load(req.getId(), CompanyResVo.class);
        if(StringHelper.isEmpty(companyResVo)){
            return;
        }
        String expirationDate = companyResVo.getExpirationDate();
        Date toDate = DateHelper.getDateTime(DateHelper.toDay(DateHelper.getDateTime(expirationDate)));
        Date today = DateHelper.getDateTime(DateHelper.toDay(getCurDate()));
        long day = DateHelper.betweenDay(toDate, today);
        // 过期时间 - 今天 = 还有几天过期 今天日期到过期日期还有几天
        if(day <= 30 && day >= 0){
            // 提示消息还有多少天到期
            CompanyMsgReqVo companyMsgReqVo = new CompanyMsgReqVo();
            companyMsgReqVo.setCompanyId(companyResVo.getId());
            companyMsgReqVo.setCompanyName(companyResVo.getCompanyName());
            companyMsgReqVo.setMsgContent("您的账号还有" + day + "天到期，请尽快充值或者联系管理员。" );
            companyMsgReqVo.setMsgType(1);
            companyMsgReqVo.setType(0);
            companyMsgReqVo.setId(StringHelper.getNewID());
            companyMsgDao.create(companyMsgReqVo);

            CompanyVo companyVo = new CompanyVo();
            ObjectHelper.writeWithFromClass(companyVo, companyResVo);
            companyVo.setExpirationMsg("您的账号还有" + day + "天到期，请尽快充值或者联系管理员。");
            companyDao.update(companyVo);
        }else{
            CompanyVo companyVo = new CompanyVo();
            ObjectHelper.writeWithFromClass(companyVo, companyResVo);
            companyVo.setExpirationMsg("");
            companyDao.update(companyVo);
        }

    }

}
