package com.pangding.web.company.dao.impl;

import com.pangding.web.company.dao.CompanyOtherMoneyDao;
import com.pangding.web.vo2.user.company.pd.CompanyOtherMoneyVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyQueryPageReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyUpdateReqVo;
import com.pangding.web.vo2.user.company.res.CompanyOtherMoneyQueryResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyOtherMoneyDaoImpl extends BaseDaoImpl implements CompanyOtherMoneyDao {

    private static final String QUERY_COMPANY_MONEY = "QUERY_COMPANY_MONEY";

    private static final String UPDATE_COMPANY_MONEY = "UPDATE_COMPANY_MONEY";


    @Override
    protected void init() {
        register(CompanyOtherMoneyVo.class);

        table.add(QUERY_COMPANY_MONEY,"select  a.*,b.company_pid as companyPid,b.company_pname as companyPname" +
                " from pd_company_other_money a " +
                " left join pd_company_relation b on a.company_other_money_id = b.relation_id" +
                " where 1=1 {WHERE} order by create_time desc")
                .add("","")
                .add("companyPid"," and b.company_pid = ? ")
                .add("companyId"," and a.company_id = ? ")
                .add("merchantId"," and a.merchant_id = ? ")

                .add("superOtherMoneyType", " and a.super_other_money_type =  ? ")
                .add("moneyStatus", " and a.money_status =  ? ")

                .add("companyName"," and a.company_name LIKE concat('%', ?,'%')  ")
                .add("merchantName"," and a.merchant_name LIKE concat('%', ?,'%')  ");

        table.add(UPDATE_COMPANY_MONEY,"update pd_company_other_money set other_money = other_money + @otherMoney " +
                " where company_id = @companyId and merchant_id =@merchantId " );

    }

    @Override
    public PageSizeData<CompanyOtherMoneyQueryResVo> queryCompanyOtherMoneyPage(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return this.queryPage(CompanyOtherMoneyQueryResVo.class,reqVo,QUERY_COMPANY_MONEY,reqVo);
    }

    @Override
    public List<CompanyOtherMoneyQueryResVo> queryCompanyOtherMoneyList(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return this.query(CompanyOtherMoneyQueryResVo.class,QUERY_COMPANY_MONEY,reqVo);
    }

    @Override
    public CompanyOtherMoneyQueryResVo queryCompanyOtherMoney(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return this.queryFirst(CompanyOtherMoneyQueryResVo.class,QUERY_COMPANY_MONEY,reqVo);
    }

    @Override
    public void updateMoney(CompanyOtherMoneyUpdateReqVo req) {
        this.updateSql(UPDATE_COMPANY_MONEY, req);
    }
}
