package com.pangding.web.company.service.impl;

import com.pangding.web.authority.dao.company.CompanyRelationDao;
import com.pangding.web.company.dao.CompanyOtherMoneyDao;
import com.pangding.web.company.service.CompanyOtherMoneyDatabase;
import com.pangding.web.company.vo.CompanyOtherMoneyTemp;
import org.springframework.stereotype.Component;

@Component
public class CompanyOtherMoneyDatabaseImpl implements CompanyOtherMoneyDatabase {

    private CompanyRelationDao companyRelationDao;
    private CompanyOtherMoneyDao companyOtherMoneyDao;

    public CompanyOtherMoneyDatabaseImpl(CompanyRelationDao companyRelationDao, CompanyOtherMoneyDao companyOtherMoneyDao) {
        this.companyRelationDao = companyRelationDao;
        this.companyOtherMoneyDao = companyOtherMoneyDao;
    }

    public void saveDatabase(CompanyOtherMoneyTemp temp){
        companyRelationDao.createList(temp.getCompanyRelationVoList());
        companyOtherMoneyDao.createList(temp.getCompanyOtherMoneyVoList());
    }
}
