package com.pangding.web.company.service.impl;

import com.pangding.web.company.service.CompanyOtherMoneySaveService;
import com.pangding.web.company.vo.CompanyOtherMoneyTemp;
import com.pangding.web.company.vo.CompanyOtherMoneyUtil;
import com.pangding.web.constant.PangdConstant;
import com.pangding.web.vo.system.pd.company.CompanyRelationVo;
import com.pangding.web.vo2.user.company.pd.CompanyOtherMoneyVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneySaveReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyOtherMoneySaveServiceImpl implements CompanyOtherMoneySaveService {


    private CompanyOtherMoneyUtil companyOtherMoneyUtil;

    public CompanyOtherMoneySaveServiceImpl(CompanyOtherMoneyUtil companyOtherMoneyUtil) {
        this.companyOtherMoneyUtil = companyOtherMoneyUtil;
    }

    public void companyOtherMoneySaveHand(CompanyOtherMoneyTemp temp, CompanyOtherMoneySaveReqVo req){

        if(PangdConstant.SOURCE_TYPE_BUSIN == req.getSourceType()){
            // 商户来源
            List<CompanyOtherMoneyVo> companyOtherMoneyList = req.getCompanyOtherMoneyList();
            for(CompanyOtherMoneyVo companyOtherMoneyVo: companyOtherMoneyList){

                String companyOtherMoneyId = StringHelper.getNewID();
                CompanyOtherMoneyVo companyOtherMoney = companyOtherMoneyUtil.checkCompanyOtherMoney(companyOtherMoneyVo.getMerchantId(),
                        companyOtherMoneyVo.getCompanyId());
                if (StringHelper.isEmpty(companyOtherMoney)) {
                    companyOtherMoney = new CompanyOtherMoneyVo();
                    ObjectHelper.writeWithFromClass(companyOtherMoney, companyOtherMoneyVo);
                    companyOtherMoney.setCompanyOtherMoneyId(companyOtherMoneyId);
                    companyOtherMoney.setCreateTime(DateHelper.getNow());
                    temp.getCompanyOtherMoneyVoList().add(companyOtherMoney);
                }

                if (!StringHelper.isEmpty(req.getCompanyId())){
                    // 检查改公司是否已经添加
                    CompanyRelationVo companyRelationVo = companyOtherMoneyUtil.checkCompanyRelation(req.getCompanyId(),
                            companyOtherMoneyVo.getCompanyId(), companyOtherMoney.getCompanyOtherMoneyId());
                    if (StringHelper.isEmpty(companyRelationVo)) {
                        companyRelationVo = new CompanyRelationVo();
                        companyRelationVo.setCompanyId(companyOtherMoneyVo.getCompanyId());
                        companyRelationVo.setCompanyName(companyOtherMoneyVo.getCompanyName());
                        companyRelationVo.setCompanyPid(req.getCompanyId());
                        companyRelationVo.setCompanyPname(req.getCompanyName());
                        companyRelationVo.setCreateTime(DateHelper.getNow());
                        companyRelationVo.setCompanyRelationId(StringHelper.getNewID());
                        companyRelationVo.setRelationType("2");
                        companyRelationVo.setRelationId(companyOtherMoneyId);
                        temp.getCompanyRelationVoList().add(companyRelationVo);
                    }
                }
            }
        }

    }



}
