package com.pangding.web.company.service.impl;

import com.pangding.web.authority.dao.company.CompanyRelationDao;
import com.pangding.web.company.dao.CompanyOtherMoneyDao;
import com.pangding.web.company.service.CompanyOtherMoenyService;
import com.pangding.web.company.service.CompanyOtherMoneyDatabase;
import com.pangding.web.company.service.CompanyOtherMoneySaveService;
import com.pangding.web.company.vo.CompanyOtherMoneyTemp;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.vo.system.pd.company.CompanyRelationVo;
import com.pangding.web.vo2.user.company.pd.CompanyOtherMoneyVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyDelReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyQueryPageReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneySaveReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyUpdateReqVo;
import com.pangding.web.vo2.user.company.res.CompanyOtherMoneyQueryResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyOtherMoneyServiceImpl implements CompanyOtherMoenyService {

    private CompanyOtherMoneyDao companyOtherMoneyDao;

    private CompanyRelationDao companyRelationDao;

    private List<CompanyOtherMoneySaveService> companyOtherMoneySaveService;

    private List<CompanyOtherMoneyDatabase> companyOtherMoneyDatabases;

    public CompanyOtherMoneyServiceImpl(CompanyOtherMoneyDao companyOtherMoneyDao, CompanyRelationDao companyRelationDao,
                                        List<CompanyOtherMoneySaveService> companyOtherMoneySaveService,
                                        List<CompanyOtherMoneyDatabase> companyOtherMoneyDatabases) {
        this.companyOtherMoneyDao = companyOtherMoneyDao;
        this.companyRelationDao = companyRelationDao;
        this.companyOtherMoneySaveService = companyOtherMoneySaveService;
        this.companyOtherMoneyDatabases = companyOtherMoneyDatabases;
    }

    public PageSizeData<CompanyOtherMoneyQueryResVo> queryCompanyOtherMoneyPage(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return companyOtherMoneyDao.queryCompanyOtherMoneyPage(reqVo);
    }


    public List<CompanyOtherMoneyQueryResVo> queryCompanyOtherMoneyList(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return companyOtherMoneyDao.queryCompanyOtherMoneyList(reqVo);
    }


    public CompanyOtherMoneyQueryResVo queryCompanyOtherMoney(CompanyOtherMoneyQueryPageReqVo reqVo) {
        return companyOtherMoneyDao.queryCompanyOtherMoney(reqVo);
    }


    public String saveCompanyOtherMoney(CompanyOtherMoneySaveReqVo req) {

        CompanyOtherMoneyTemp companyOtherMoneyTemp = new CompanyOtherMoneyTemp();

        companyOtherMoneySaveService.forEach(k -> k.companyOtherMoneySaveHand(companyOtherMoneyTemp, req));

        companyOtherMoneyDatabases.forEach(k -> k.saveDatabase(companyOtherMoneyTemp));

        return "提交成功";

    }

    public String updateCompanyOtherMoney(CompanyOtherMoneyUpdateReqVo req) {
        CompanyOtherMoneyVo companyOtherMoneyVo = companyOtherMoneyDao.load(req.getCompanyOtherMoneyId(), CompanyOtherMoneyVo.class);
        if (StringHelper.isEmpty(companyOtherMoneyVo)) {
            throw new CodeException("未找到信息");
        }
        if(CompanyConstant.SUPEY_MONEY_TYPE_SUPER == companyOtherMoneyVo.getSuperOtherMoneyType()){
            CompanyRelationVo companyRelationReqVo = new CompanyRelationVo();
            companyRelationReqVo.setCompanyId(req.getCompanyId());
            companyRelationReqVo.setRelationId(companyOtherMoneyVo.getCompanyOtherMoneyId());
            CompanyRelationVo companyRelationVo = companyRelationDao.load(companyRelationReqVo, CompanyRelationVo.class);
            if(!StringHelper.isEmpty(companyRelationVo)){
                if(!req.getCompanyPid().equals(companyRelationVo.getCompanyPid())){
                    throw new CodeException("上级公司不一致，不能修改上级公司。请先删除，在新增。");
                }
            }
        }
        ObjectHelper.writeWithFromClass(companyOtherMoneyVo, req);
        companyOtherMoneyDao.update(companyOtherMoneyVo);

        return "提交成功";

    }

    public void delCOmpanyOtherMoney(CompanyOtherMoneyDelReqVo req) {
        CompanyOtherMoneyVo companyOtherMoneyVo = companyOtherMoneyDao.load(req.getCompanyOtherMoneyId(), CompanyOtherMoneyVo.class);
        if (!StringHelper.isEmpty(companyOtherMoneyVo)) {
            if (!StringHelper.isEmpty(companyOtherMoneyVo.getSuperOtherMoneyType())
                    && CompanyConstant.SUPEY_MONEY_TYPE_SUPER == companyOtherMoneyVo.getSuperOtherMoneyType()) {
                CompanyRelationVo del = new CompanyRelationVo();
                del.setCompanyId(req.getCompanyId());
                del.setCompanyPid(req.getCompanyPid());
                companyRelationDao.remove(del);
//                CompanyOtherMoneyVo companyOtherMoneyVo1 = new CompanyOtherMoneyVo();
//                companyOtherMoneyVo1.setCompanyId(companyOtherMoneyVo.getCompanyId());
//                companyOtherMoneyVo1.setSuperOtherMoneyType(CompanyConstant.SUPEY_MONEY_TYPE_SUPER);
//                List<CompanyOtherMoneyVo> list = companyOtherMoneyDao.loadList(companyOtherMoneyVo1, CompanyOtherMoneyVo.class);
//                if(StringHelper.isEmpty(list) && list.size() == 0){
//
//                }
            }
            if(!StringHelper.isEmpty(companyOtherMoneyVo.getSuperOtherMoneyType())
                    && CompanyConstant.SUPEY_MONEY_TYPE_SELF == companyOtherMoneyVo.getSuperOtherMoneyType()){
                // 删除上级 需要查询是否有下级 需一起删除 TODO
                CompanyRelationVo delReq = new CompanyRelationVo();
                delReq.setCompanyPid(companyOtherMoneyVo.getCompanyId());
                List<CompanyRelationVo> companyRelationVoList = companyRelationDao.loadList(delReq, CompanyRelationVo.class);
                for(CompanyRelationVo companyRelationVo: companyRelationVoList){
                    CompanyOtherMoneyVo companyOtherMoneyCli = companyOtherMoneyDao.load(companyRelationVo.getRelationId(), CompanyOtherMoneyVo.class);
                    companyOtherMoneyDao.remove(companyOtherMoneyCli);
                    companyRelationDao.remove(companyRelationVo);
                }

            }
            companyOtherMoneyDao.remove(companyOtherMoneyVo);
        }
    }

    public String updateMoney(CompanyOtherMoneyUpdateReqVo req) {
        System.err.println("处理余额开始：" + JsonHelper.serialize(req));
        CompanyOtherMoneyUpdateReqVo updateReq = new CompanyOtherMoneyUpdateReqVo();
        updateReq.setCompanyId(req.getCompanyId());
        updateReq.setMerchantId(req.getMerchantId());
        double otherMoney = 0;
        double superOther = 0;
        if(!StringHelper.isEmpty(req.getMoneyType()) && 11 == req.getMoneyType()){
            // 消费
            otherMoney = -req.getOtherMoney();
            superOther = -req.getSuperOtherMoney();
        }
        if(!StringHelper.isEmpty(req.getMoneyType()) && 12 == req.getMoneyType()){
            // 退票
            otherMoney = req.getOtherMoney();
            superOther = req.getSuperOtherMoney();
        }
        updateReq.setOtherMoney(otherMoney);
        System.err.println("处理分销商余额：" + JsonHelper.serialize(updateReq));
        if(updateReq.getOtherMoney() >0 || updateReq.getOtherMoney() <0 ){
            companyOtherMoneyDao.updateMoney(updateReq);
        }

        CompanyOtherMoneyVo companyOtherMoneyReqVo = new CompanyOtherMoneyVo();
        companyOtherMoneyReqVo.setCompanyId(req.getCompanyId());
        companyOtherMoneyReqVo.setMerchantId(req.getMerchantId());
        CompanyOtherMoneyVo companyOtherMoneyVo = companyOtherMoneyDao.load(companyOtherMoneyReqVo, CompanyOtherMoneyVo.class);
        if (!StringHelper.isEmpty(companyOtherMoneyVo)) {
            if(CompanyConstant.SUPEY_MONEY_TYPE_SUPER == companyOtherMoneyVo.getSuperOtherMoneyType()){
                // 上级分配的余额
                CompanyRelationVo reqVo = new CompanyRelationVo();
                reqVo.setCompanyId(companyOtherMoneyVo.getCompanyId());
                reqVo.setRelationId(companyOtherMoneyVo.getCompanyOtherMoneyId());
                CompanyRelationVo companyRelationVo = companyRelationDao.load(reqVo, CompanyRelationVo.class);
                if(!StringHelper.isEmpty(companyRelationVo)){
                    CompanyOtherMoneyUpdateReqVo superUpdateReq = new CompanyOtherMoneyUpdateReqVo();
                    superUpdateReq.setCompanyId(companyRelationVo.getCompanyPid());
                    superUpdateReq.setMerchantId(req.getMerchantId());
                    superUpdateReq.setOtherMoney(superOther);
                    System.err.println("处理代理商余额：" + JsonHelper.serialize(superUpdateReq));
                    if(updateReq.getOtherMoney() >0 || updateReq.getOtherMoney() <0 ){
                        companyOtherMoneyDao.updateMoney(superUpdateReq);
                    }

                }
            }
        }


        return "提交成功";

    }

}
