package com.pangding.web.company.service.impl;

import com.pangding.web.company.dao.CompanyOtherMoneyDao;
import com.pangding.web.company.dao.CompanyRechargeDao;
import com.pangding.web.company.service.CompanyRechargeService;
import com.pangding.web.vo2.user.company.pd.CompanyOtherMoneyVo;
import com.pangding.web.vo2.user.company.pd.CompanyRechargeVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyUpdateReqVo;
import com.pangding.web.vo2.user.company.req.CompanyRechargeSaveReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Component;

@Component
public class CompanyRechargeServiceImpl implements CompanyRechargeService {

    private CompanyOtherMoneyDao companyOtherMoneyDao;

    private CompanyRechargeDao companyRechargeDao;

    public CompanyRechargeServiceImpl(CompanyOtherMoneyDao companyOtherMoneyDao, CompanyRechargeDao companyRechargeDao) {
        this.companyOtherMoneyDao = companyOtherMoneyDao;
        this.companyRechargeDao = companyRechargeDao;
    }

    public void saveCompanyRecharge(CompanyRechargeSaveReqVo req){
        CompanyOtherMoneyVo moneyReq = new CompanyOtherMoneyVo();
        moneyReq.setCompanyId(req.getCompanyId());
        moneyReq.setMerchantId(req.getMerchantId());
        moneyReq.setOtherMoneyType(req.getOtherMoneyType());
        CompanyOtherMoneyVo companyOtherMoneyVo = companyOtherMoneyDao.load(moneyReq, CompanyOtherMoneyVo.class);
        if(!StringHelper.isEmpty(companyOtherMoneyVo)){
            CompanyOtherMoneyUpdateReqVo companyOtherMoneyUpdateReqVo = new CompanyOtherMoneyUpdateReqVo();
            ObjectHelper.writeWithFromClass(companyOtherMoneyUpdateReqVo, companyOtherMoneyVo);
            companyOtherMoneyUpdateReqVo.setOtherMoney(req.getOtherMoney());
            companyOtherMoneyDao.updateMoney(companyOtherMoneyUpdateReqVo);

            CompanyRechargeVo companyRechargeVo = new CompanyRechargeVo();
            ObjectHelper.writeWithFromClass(companyRechargeVo, req);
            companyRechargeVo.setCompanyOtherMoneyId(companyOtherMoneyVo.getCompanyOtherMoneyId());
            companyRechargeVo.setCompanyRechargeId(StringHelper.getNewID());
            companyRechargeDao.create(companyRechargeVo);
        }

    }

}
