package com.pangding.web.company.vo;

import com.pangding.web.authority.dao.company.CompanyRelationDao;
import com.pangding.web.company.dao.CompanyOtherMoneyDao;
import com.pangding.web.vo.system.pd.company.CompanyRelationVo;
import com.pangding.web.vo2.user.company.pd.CompanyOtherMoneyVo;
import org.springframework.stereotype.Component;

@Component
public class CompanyOtherMoneyUtil {

    private CompanyRelationDao companyRelationDao;

    private CompanyOtherMoneyDao companyOtherMoneyDao;

    public CompanyOtherMoneyUtil(CompanyRelationDao companyRelationDao, CompanyOtherMoneyDao companyOtherMoneyDao) {
        this.companyRelationDao = companyRelationDao;
        this.companyOtherMoneyDao = companyOtherMoneyDao;
    }

    public CompanyRelationVo checkCompanyRelation(String companyPid, String companyId, String relationId){
        CompanyRelationVo req = new CompanyRelationVo();
        req.setCompanyPid(companyPid);
        req.setCompanyId(companyId);
        req.setRelationId(relationId);
        CompanyRelationVo companyRelationVo = companyRelationDao.load(req, CompanyRelationVo.class);
        return companyRelationVo;
    }


    public CompanyOtherMoneyVo checkCompanyOtherMoney(String merchantId, String companyId){
        CompanyOtherMoneyVo req = new CompanyOtherMoneyVo();
        req.setCompanyId(companyId);
        req.setMerchantId(merchantId);
        CompanyOtherMoneyVo companyOtherMoneyVo = companyOtherMoneyDao.load(req, CompanyOtherMoneyVo.class);
        return companyOtherMoneyVo;
    }

}
