package com.pangding.web.company.web;

import com.pangding.web.company.service.CompanyOtherMoenyService;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyDelReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyQueryPageReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneySaveReqVo;
import com.pangding.web.vo2.user.company.req.CompanyOtherMoneyUpdateReqVo;
import com.pangding.web.vo2.user.company.res.CompanyOtherMoneyQueryResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/companyOtherMoney", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "代购公司余额", description = "代购公司授信余额管理")
public class CompanyOtherMoneyController {

    private CompanyOtherMoenyService companyOtherMoenyService;

    public CompanyOtherMoneyController(CompanyOtherMoenyService companyOtherMoenyService) {
        this.companyOtherMoenyService = companyOtherMoenyService;
    }

    @RequestMapping(value = "/queryCompanyOtherMoneyPage")
    @ApiOperation(value = "找到下级公司的余额情况", notes = "返回下级公司的余额")
    public ResponseResult<PageSizeData<CompanyOtherMoneyQueryResVo>> queryCompanyOtherMoneyPage(@RequestBody CompanyOtherMoneyQueryPageReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("companyPid", req.getCompanyPid())
                .checkException();
        if("10001".equals(req.getCompanyPid())){
            req.setCompanyPid("");
        }
        return ResponseResult.result(companyOtherMoenyService.queryCompanyOtherMoneyPage(req));
    }

    @RequestMapping(value = "/queryCompanyOtherMoneyList")
    @ApiOperation(value = "找到公司的余额情况", notes = "返回公司的余额")
    public ResponseResult<List<CompanyOtherMoneyQueryResVo>> queryCompanyOtherMoneyList(@RequestBody CompanyOtherMoneyQueryPageReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        if("10001".equals(req.getCompanyId())){
            req.setCompanyId("");
        }
        return ResponseResult.result(companyOtherMoenyService.queryCompanyOtherMoneyList(req));
    }

    @RequestMapping(value = "/queryCompanyOtherMoney")
    @ApiOperation(value = "查询详情", notes = "返回成功")
    public ResponseResult<CompanyOtherMoneyQueryResVo> queryCompanyOtherMoney(@RequestBody CompanyOtherMoneyQueryPageReqVo req) {
//        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
//                .checkException();
        return ResponseResult.result(companyOtherMoenyService.queryCompanyOtherMoney(req));
    }

    @RequestMapping(value = "/saveCompanyOtherMoney")
    @ApiOperation(value = "保存公司其他余额", notes = "返回成功")
    public ResponseResult<String> saveCompanyOtherMoney(@RequestBody CompanyOtherMoneySaveReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("sourceType", req.getSourceType())
                .checkException();
        return ResponseResult.result(companyOtherMoenyService.saveCompanyOtherMoney(req));
    }

    @RequestMapping(value = "/updateCompanyOtherMoney")
    @ApiOperation(value = "修改公司其他余额", notes = "返回成功")
    public ResponseResult<String> updateCompanyOtherMoney(@RequestBody CompanyOtherMoneyUpdateReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("compnayOtherMoneyId", req.getCompanyOtherMoneyId())
                .checkException();
        return ResponseResult.result(companyOtherMoenyService.updateCompanyOtherMoney(req));
    }


    @RequestMapping(value = "/delCompanyOtherMoney")
    @ApiOperation(value = "删除公司其他余额", notes = "返回成功")
    public ResponseResult<String> delCompanyOtherMoney(@RequestBody CompanyOtherMoneyDelReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("compnayOtherMoneyId", req.getCompanyOtherMoneyId())
                .checkException();
        companyOtherMoenyService.delCOmpanyOtherMoney(req);
        return ResponseResult.resultAllowNull("");
    }
}
