package com.pangding.web.company.web;

import com.pangding.web.company.service.CompanyRechargeService;
import com.pangding.web.vo2.user.company.req.CompanyRechargeSaveReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/companyRecharge", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "代购公司余额充值记录管理", description = "代购公司余额充值记录管理")
public class CompanyRechargeController {

    private CompanyRechargeService companyRechargeService;

    public CompanyRechargeController(CompanyRechargeService companyRechargeService) {
        this.companyRechargeService = companyRechargeService;
    }

    @RequestMapping(value = "/saveCompanyRecharge")
    @ApiOperation(value = "保存代购公司余额充值记录", notes = "返回成功")
    public ResponseResult<String> saveCompanyRecharge(@RequestBody CompanyRechargeSaveReqVo req) {
        companyRechargeService.saveCompanyRecharge(req);
        return ResponseResult.result("返回成功");
    }


}
