package com.pangding.web.report.web;

import com.pangding.web.report.service.V2IndexService;
import com.pangding.web.vo.order.req.report.DataAnalysisBaseReqVo;
import com.pangding.web.vo.order.req.report.ReportDayFlowReqVo;
import com.pangding.web.vo.order.res.report.DataAnalysisBaseResVo;
import com.pangding.web.vo.order.res.report.ReportDayFlowResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value="/v2/index",  method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class V2IndexController {

    private V2IndexService v2IndexService;

    public V2IndexController(V2IndexService v2IndexService) {
        this.v2IndexService = v2IndexService;
    }

    /**
     * 首页流水
     */
    @RequestMapping(value = "/indexData")
    @ApiOperation(value = "首页合计数据", notes = "6.首页合计数据")
    public ResponseResult<ReportDayFlowResVo> pdIndexData(@RequestBody ReportDayFlowReqVo reqVo) {
        CheckerHelper.newInstance()
                .notBlankCheck("companyId", reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(v2IndexService.indexDataV2(reqVo));
    }

    /**
     * B端首页数据分析月(实际是该月中每一天)
     */
    @RequestMapping(value = "/capitalAndOrderDay")
    @ApiOperation(value = "资金流水和交易订单数据", notes = "资金流水和交易订单数据")
    public ResponseResult<DataAnalysisBaseResVo> capitalAndOrderDay(@RequestBody DataAnalysisBaseReqVo req) {
        CheckerHelper check = CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        return ResponseResult.result(v2IndexService.capitalAndOrderDay(req));
    }

    /**
     * B端首页数据分析月(实际是该月中每一天)
     */
    @RequestMapping(value = "/capitalAndOrderMonth")
    @ApiOperation(value = "资金流水和交易订单数据", notes = "资金流水和交易订单数据")
    public ResponseResult<DataAnalysisBaseResVo> capitalAndOrderMonth(@RequestBody DataAnalysisBaseReqVo req) {
        CheckerHelper check = CheckerHelper.newInstance()
                .notBlankCheck("companyId", req.getCompanyId())
                .checkException();
        return ResponseResult.result(v2IndexService.capitalAndOrderMonth(req));
    }
}
