package com.tcm.common.web;

import com.tcm.common.service.CarouselService;
import com.tcm.util.common.req.CarouselLoadPageReqVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/carousel")
public class CarouselController {

    private final CarouselService carouselService;

    public CarouselController(CarouselService carouselService) {
        this.carouselService = carouselService;
    }

    /**
     * 内容新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.save(req));

    }
    /**
     * 内容加载
     */
    @RequestMapping("/load")
    public ResponseResult<CarouselResVo> load(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.load(req));

    }
    /**
     * 内容列表
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<CarouselResVo>> loadPage(@RequestBody CarouselLoadPageReqVo req) {
        return ResponseResult.result(carouselService.loadPage(req));

    }


    /**
     * 上下架
     */
    @RequestMapping("/changeStatus")
    public ResponseResult<String> changeStatus(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.changeStatus(req));

    }

    /**
     * 内容删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.remove(req));

    }
}
