package com.tcm.doctor.service.impl;

import com.tcm.doctor.dao.DoctorDao;
import com.tcm.doctor.dao.DoctorScheduleDao;
import com.tcm.doctor.service.DoctorService;
import com.tcm.util.doctor.DoctorScheduleVo;
import com.tcm.util.doctor.DoctorVo;
import com.tcm.util.doctor.req.DoctorLoadPageReqVo;
import com.tcm.util.doctor.req.DoctorReqVo;
import com.tcm.util.doctor.res.DoctorResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class DoctorServiceImpl implements DoctorService {

    private final DoctorDao doctorDao;
    private final DoctorScheduleDao doctorScheduleDao;

    public DoctorServiceImpl(DoctorDao doctorDao, DoctorScheduleDao doctorScheduleDao) {
        this.doctorDao = doctorDao;
        this.doctorScheduleDao = doctorScheduleDao;
    }


    @Override
    public String save(DoctorReqVo req) {
        if (StringHelper.isEmpty(req.getDoctorId())) {
            String doctorId = StringHelper.getNewID();
            DoctorVo doctor = new DoctorVo();
            doctor.setDoctorId(doctorId);
            ObjectHelper.writeWithFrom(doctor, req);
            doctor.setCreateTime(DateHelper.getNow());
            doctorDao.create(doctor);
            return doctorId;
        } else {
            DoctorVo doctor = new DoctorVo();
            doctor.setDoctorId(req.getDoctorId());
            DoctorVo load = doctorDao.load(doctor, DoctorVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            doctorDao.update(load);
            return req.getDoctorId();
        }
    }

    @Override
    public DoctorResVo load(DoctorReqVo req) {
        DoctorVo doctor = new DoctorVo();
        doctor.setDoctorId(req.getDoctorId());
        DoctorResVo load = doctorDao.load(doctor, DoctorResVo.class);
        return load;
    }

    @Override
    public PageSizeData<DoctorResVo> loadPage(DoctorLoadPageReqVo req) {
        PageSizeData<DoctorResVo> page = doctorDao.loadPage(req, DoctorResVo.class);
        return page;
    }

    @Override
    public String changeStatus(DoctorReqVo req) {
        DoctorVo doctor = new DoctorVo();
        doctor.setDoctorId(req.getDoctorId());
        DoctorVo load = doctorDao.load(doctor, DoctorVo.class);
        load.setStatus(req.getStatus());
        doctorDao.update(load);
        return req.getDoctorId();
    }

    @Override
    public String remove(DoctorReqVo req) {
        DoctorVo doctor = new DoctorVo();
        doctor.setDoctorId(req.getDoctorId());
        doctorDao.remove(doctor);
        DoctorScheduleVo doctorSchedule = new DoctorScheduleVo();
        doctorSchedule.setDoctorId(req.getDoctorId());
        doctorScheduleDao.remove(doctorSchedule);
        return req.getDoctorId();
    }
}
