package com.tcm.doctor.web;

import com.tcm.doctor.service.DoctorService;
import com.tcm.util.doctor.req.DoctorLoadPageReqVo;
import com.tcm.util.doctor.req.DoctorReqVo;
import com.tcm.util.doctor.res.DoctorResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("/doctor")
public class DoctorController {

    private final DoctorService doctorService;

    public DoctorController(DoctorService doctorService) {
        this.doctorService = doctorService;
    }

    /**
     * 医生新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody DoctorReqVo req) {
        return ResponseResult.result(doctorService.save(req));

    }

    /**
     * 医生加载
     */
    @RequestMapping("/load")
    public ResponseResult<DoctorResVo> load(@RequestBody DoctorReqVo req) {
        return ResponseResult.result(doctorService.load(req));

    }

    /**
     * 医生分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<DoctorResVo>> loadPage(@RequestBody DoctorLoadPageReqVo req) {
        return ResponseResult.result(doctorService.loadPage(req));

    }

    /**
     * 医生上下架
     */
    @RequestMapping("/changeStatus")
    public ResponseResult<String> changeStatus(@RequestBody DoctorReqVo req) {
        return ResponseResult.result(doctorService.changeStatus(req));

    }

    /**
     * 医生删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody DoctorReqVo req) {
        return ResponseResult.result(doctorService.remove(req));

    }
}
