package com.tcm.doctor.web;

import com.tcm.doctor.service.DoctorScheduleService;
import com.tcm.util.doctor.req.DoctorLoadPageReqVo;
import com.tcm.util.doctor.req.DoctorScheduleReqVo;
import com.tcm.util.doctor.res.DoctorScheduleResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/doctorSchedule")
public class DoctorScheduleController {

    private final DoctorScheduleService doctorScheduleService;

    public DoctorScheduleController(DoctorScheduleService doctorScheduleService) {
        this.doctorScheduleService = doctorScheduleService;
    }


    /**
     * 医生排班新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody DoctorScheduleReqVo req) {
        return ResponseResult.result(doctorScheduleService.save(req));

    }

    /**
     * 医生排班加载
     */
    @RequestMapping("/load")
    public ResponseResult<List<DoctorScheduleResVo>> load(@RequestBody DoctorScheduleReqVo req) {
        return ResponseResult.result(doctorScheduleService.load(req));

    }

    /**
     * 医生排班分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<DoctorScheduleResVo>> loadPage(@RequestBody DoctorLoadPageReqVo req) {
        return ResponseResult.result(doctorScheduleService.loadPage(req));

    }

    /**
     * 医生排班删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody DoctorScheduleReqVo req) {
        return ResponseResult.result(doctorScheduleService.remove(req));

    }
}
