package com.tcm.product.service;

import com.tcm.util.product.req.ProductCategoryLoadPageReqVo;
import com.tcm.util.product.req.ProductCategoryReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.yanzuoguang.util.vo.PageSizeData;

public interface ProductCategoryService {
    /**
     * 产品分类保存
     *
     * @param req
     * @return
     */
    String save(ProductCategoryReqVo req);

    /**
     * 产品分类加载
     *
     * @param req
     * @return
     */
    ProductCategoryResVo load(ProductCategoryReqVo req);

    /**
     * 产品分类分页
     *
     * @param req
     * @return
     */
    PageSizeData<ProductCategoryResVo> loadPage(ProductCategoryLoadPageReqVo req);

    /**
     * 产品分类删除
     *
     * @param req
     * @return
     */
    String remove(ProductCategoryReqVo req);

    /**
     * 首页展示产品类型
     * @param req
     * @return
     */
    PageSizeData<ProductCategoryResVo> categoryProductPage(ProductCategoryLoadPageReqVo req);
}
