package com.tcm.system.user.service.impl;

import com.tcm.system.user.dao.TokenDao;
import com.tcm.system.user.service.TokenService;
import com.tcm.system.user.vo.TcmLoginTokenVo;
import com.yanzuoguang.util.helper.JsonHelper;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl implements TokenService {

    private TokenDao tokenDao;

    public TokenServiceImpl(TokenDao tokenDao) {
        this.tokenDao = tokenDao;
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo
     */
    @Override
    public String save(TcmLoginTokenVo loginVo) {
        TcmLoginTokenVo to = tokenDao.load(loginVo, TcmLoginTokenVo.class);
        if (JsonHelper.compare(to,loginVo)) {
            return to.getToken();
        } else if (to != null) {
            return tokenDao.update(loginVo);
        } else {
            return tokenDao.create(loginVo);
        }
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public TcmLoginTokenVo load(TcmLoginTokenVo loginVo) {
        return tokenDao.load(loginVo, TcmLoginTokenVo.class);
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public int remove(TcmLoginTokenVo loginVo) {

        return tokenDao.remove(loginVo);
    }

}
