package com.tcm.system.user.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.vo.BaseVo;
import com.yanzuoguang.util.vo.InitDao;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_login_token")
public class TcmLoginTokenVo extends BaseVo implements InitDao {
    @ApiModelProperty(
            notes = "登陆凭证"
    )
    private String token;
    @ApiModelProperty(
            notes = "数据密码"
    )
    @TableAnnotation("data_pwd")
    private String dataPwd;
    @ApiModelProperty(
            notes = "数据"
    )
    private String data;
    @ApiModelProperty(
            notes = "时间"
    )
    @TableAnnotation("expair_time")
    private String expairTime;
    @ApiModelProperty(
            notes = "登录类型  0 B端登录，1C端登录，2第三方登录 3 app登录"
    )
    @TableAnnotation("login_type")
    private Integer loginType;

    public void init() {
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDataPwd() {
        return dataPwd;
    }

    public void setDataPwd(String dataPwd) {
        this.dataPwd = dataPwd;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getExpairTime() {
        return expairTime;
    }

    public void setExpairTime(String expairTime) {
        this.expairTime = expairTime;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }
}
