package com.tcm.system.user.web;

import com.tcm.system.user.service.LoginService;
import com.tcm.system.user.vo.req.UserLoginReqVo;
import com.tcm.system.user.vo.res.UserLoginResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value="login")
@Api(value = "用户登录类")
public class LoginController {

    private LoginService loginService;

    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }


    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param req
     * @return
     */
    @ApiOperation(value ="登录", notes = "返回登录信息")
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<UserLoginResVo> mobile(@RequestBody UserLoginReqVo req) throws Exception {
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone", req.getAccountOrPhone())
                .notBlankCheck("password", req.getPassword())
//                .notBlankCheck("loginType", req.getLoginType())
                .checkException();
        return ResponseResult.result(loginService.login(req));
    }

}
