package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.DeviceService;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author tangfang
 * @date 2020-08-19
 */
@Api()
@RestController
@RequestMapping("/device")
public class DevideController {

    @Autowired
    private DeviceService deviceService;

    @RequestMapping(value = "/findDeviceList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<DeviceResVo>> findDeviceList(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.findDeviceList(req);
    }


    @RequestMapping(value = "/findDeviceInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<DeviceResVo> findDeviceInfo(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.findDeviceInfo(req);
    }

    @RequestMapping(value = "/saveDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.saveDevice(req);
    }

    @RequestMapping(value = "/updateDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult updateDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.updateDevice(req);
    }

    @RequestMapping(value = "/delDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.delDevice(req);
    }

}
