package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @Author zhangjinyao
 * @create 2019/6/18 19:53
 */
@RestController
@RequestMapping(value = "/finance",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "余额", description = "余额")
public class FinanceController {
    @Autowired
    private FinanceService financeServiceImpl;

    @PostMapping(value = "/withdrawal")
    @ApiOperation(value = "公司余额查询", notes = "返回公司余额信息")
    public ResponseResult<WithdrawalResVo> withdrawal(@RequestBody WithdrawalReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(financeServiceImpl.withdrawal(reqVo));
    }

}
