package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.vo.reqvo.CountByRoleReqVo;
import com.pangding.web.authority.vo.reqvo.ListUserReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetSuperAdminReqVo;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @author zhangjinyao
 */
@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {


    private static final String SELECT = "SELECT";
    private static final String CHECK_ACCOUNT = "CHECK_ACCOUNT";
    private static final String GET_ADMIN = "GET_ADMIN";
    private static final String COUNT_BY_ROLE = "COUNT_BY_ROLE";

    @Override
    protected void init() {
        register(UserVo.class);

        table.add(SELECT,"select * from pd_user where 1=1");

        table.addExist(CHECK_ACCOUNT,"account");

        table.add(GET_ADMIN,"SELECT u.* FROM pd_user u,pd_user_role ur WHERE u.id = ur.user_id")
                .add("superAdminRoleId","and ur.role_id = ?")
                .add("companyId","and u.company_id = ? ");

        table.add(COUNT_BY_ROLE,"select u.* from pd_user u,pd_user_role ur WHERE u.id = ur.user_id")
                .add("companyId","and u.company_id = ? ")
                .add("roleId","and ur.role_id = ? ")
                .add("query","and u.name = ? or u.account = ? or phone = ?");

    }

    @Override
    public void checkAccount(UserVo account) {
        this.checkExist(CHECK_ACCOUNT,account,"用戶名已存在:"+account.getAccount());
    }

    @Override
    public UserVo getUser(UserGetReqVo reqVo) {
        return this.load(reqVo,UserVo.class);
    }

    @Override
    public UserVo getUserByCompanyId(UserGetReqVo companyId) {
        return this.load(companyId,UserVo.class);
    }

    @Override
    public PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo) {
        return this.queryPage(UserVo.class,reqVo,SELECT,reqVo);
    }

    @Override
    public UserVo getAdmin(UserGetSuperAdminReqVo reqVo) {
        return this.queryFirst(UserVo.class,GET_ADMIN,reqVo);
    }

    @Override
    public PageSizeData<UserVo> countByRole(CountByRoleReqVo reqVo) {
        return this.queryPage(UserVo.class,reqVo,COUNT_BY_ROLE,reqVo);
    }
}
