package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.RoleAuthorityDao;
import com.pangding.web.authority.vo.reqvo.RoleAuthorityGetReqVo;
import com.pangding.web.authority.vo.RoleAuthorityVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class RoleAuthorityDaoImpl extends BaseDaoImpl implements RoleAuthorityDao {

    @Override
    protected void init() {
        register(RoleAuthorityVo.class);

        getSql(DaoConst.LOAD).setSql("select ra.role_id,a.* from pd_authority a " +
                "LEFT JOIN pd_role_authority ra on ra.authority_id = a.id {INNER} " +
                "where 1=1 {WHERE} ORDER BY a.pid,a.sort" )
                .add("userId", "AND b.user_id = @userId",
                        "{INNER}", "INNER JOIN pd_user_role AS b ON ra.role_id = b.role_id")
                .add("role", " AND ra.role_id = @role")
        ;

    }

}
