package com.pangding.web.tright.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.TrightDao;
import com.pangding.web.tright.service.TrightService;
import com.pangding.web.tright.vo.TrightVo;
import org.bouncycastle.jcajce.provider.digest.MD5;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/tright")
public class TrightController {

    @Autowired
    TrightService trightServiceImpl;
    @Autowired
    TrightDao trightDao;

    /**
     * 新增权限
     * @param trightVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveTright(@RequestBody TrightVo trightVo){
        if (!trightServiceImpl.checkValid(trightVo)){
            return new Result(4001,"该权限不合法，请修改权限名或权限url",null);
        }
        trightServiceImpl.save(trightVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 修改权限信息
     * @param trightVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateTright(@RequestBody TrightVo trightVo){
        if (!trightServiceImpl.checkValid(trightVo)){
            return new Result(4001,"该权限不合法，请修改权限名或权限url",null);
        }
        trightServiceImpl.update(trightVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询权限列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listTrights(){
        List<TrightVo> list = trightServiceImpl.listAllTright();
        if (list == null){
            return new Result(4001,"暂无权限，请先添加",null);
        }
        return new Result(0,"SUCCESS",list);
    }

    /**
     * 查询一级权限
     * @return
     */
    @RequestMapping(value = "/firstLevel", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object parentTrights(){
        List<TrightVo> list = trightServiceImpl.listLevel1();
        if (list == null){
            return new Result(4001,"暂无一级权限，请先添加",null);
        }
        return new Result(0,"SUCCESS",list);
    }

    /**
     * 根据ID查询权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/role/{id}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object tright(@PathVariable String id){
        TrightVo trightVo = trightServiceImpl.getTrightById(id);
        if (trightVo == null){
            return new Result(4001,"未查询到该权限",null);
        }
        return new Result(0,"SUCCESS",trightVo);
    }

    /**
     * 删除权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable String id){
        trightServiceImpl.deleteTrightById(id);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }
}
