package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.TrightDao;
import com.pangding.web.tright.service.TrightService;
import com.pangding.web.tright.vo.TrightVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TrightServiceImpl implements TrightService {

    @Autowired
    TrightDao trightDao;
    @Override
    public void save(TrightVo trightVo) {
        trightDao.create(trightVo);
    }

    @Override
    public void update(TrightVo trightVo) {
        trightDao.update(trightVo);
    }

    @Override
    public Boolean checkValid(TrightVo trightVo) {
        int checkResult = trightDao.checkValid(trightVo);
        if(checkResult == 0){return true;}
        else{return false;}
    }

    @Override
    public TrightVo getTrightById(String id) {
        TrightVo trightVo = trightDao.getTrightById(id);
        return trightVo != null ? trightVo : null;
    }

    @Override
    public void deleteTrightById(String id) {
        trightDao.deleteRoleTright(id);
        //trightDao.deleteTrightById(id);
        trightDao.remove(id);
        trightDao.deleteByParentId(id);
    }

    @Override
    public List<TrightVo> listAllTright() {
        List<TrightVo> list = trightDao.listAll();
        return (list != null && list.size() != 0) ? list : null;
    }

    @Override
    public List<TrightVo> listLevel1() {
        List<TrightVo> list = trightDao.listLevel1();
        return (list != null && list.size() != 0) ? list : null;
    }
}
