package com.pangding.web.tright.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * 权限表
 */
@TableAnnotation("pd_authority")
public class TrightVo implements Serializable, InitDao {
    //主键id
    private String id;
    //父权限id
    private String pid;
    //权限名
    private String name;
    //权限类型
    private String type;
    //别名
    private String alias;
    //权限url
    private String url;
    @TableAnnotation("open_mode")
    //打开方式
    private String openMode;
    //描述
    private String remark;
    @TableAnnotation("create_time")
    //创建时间
    private Timestamp createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOpenMode() {
        return openMode;
    }

    public void setOpenMode(String openMode) {
        this.openMode = openMode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Timestamp getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    @Override
    public void init() {
        String createTimeString = StringHelper.getFirst(DateHelper.getDateTimeString(this.createTime), DateHelper.getNow());
        this.createTime = Timestamp.valueOf(createTimeString);
    }
}
