package com.tcm.system.authority.dao.impl;

import com.pangding.web.vo.system.pd.authority.AuthorityVo;
import com.tcm.system.authority.dao.TcmAuthorityDao;
import com.tcm.system.authority.vo.TcmAuthorityVo;
import com.tcm.system.authority.vo.req.TcmAuthorityPageReqVo;
import com.tcm.system.authority.vo.req.TcmAuthorityReqVo;
import com.tcm.system.authority.vo.res.TcmAuthorityResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class TcmAuthorityDaoImpl extends BaseDaoImpl implements TcmAuthorityDao {

    private static final String QUERY = "QUERY";

    @Override
    protected void init() {

        register(TcmAuthorityVo.class);

        table.add(QUERY,"select * from pd_authority where 1=1")
                .add("id","and pid = ? ")
                .add("pid","and pid = ? ")
                .add("sort","and sort = ? ")
                .add("search", "and (name like concat(?,'%') " +
                        "or alias like concat(?,'%')) " )
                .add("levelOne","and pid = '' order by sort asc");

        }

    /**
     * 获取权限分页对象
     *
     * @param reqVo
     * @return 权限分页对象
     */
    @Override
    public PageSizeData<TcmAuthorityResVo> findAuthorityPage(TcmAuthorityPageReqVo reqVo) {
        return this.queryPage(TcmAuthorityResVo.class,reqVo,QUERY,reqVo);
    }

    @Override
    public List<TcmAuthorityResVo> findAuthorityList(TcmAuthorityReqVo reqVo) {
        return  this.query(TcmAuthorityResVo.class,QUERY,reqVo);
    }

}
