package com.tcm.system.authority.dao.impl;

import com.tcm.system.authority.dao.TcmRoleAuthorityDao;
import com.tcm.system.authority.vo.TcmRoleAuthorityVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @author zhangjinyao
 */
@Component
public class TcmRoleAuthorityDaoImpl extends BaseDaoImpl implements TcmRoleAuthorityDao {

    @Override
    protected void init() {
        register(TcmRoleAuthorityVo.class);

        getSql(DaoConst.LOAD).setSql("select ra.role_id,ra.authority_id,a.id,a.pid,a.name," +
                "a.type,a.alias,a.url,a.remark,a.open_mode,a.sort,a.attribute from pd_role_authority ra  " +
                "RIGHT JOIN pd_authority a on ra.authority_id = a.id {INNER} " +
                "where 1=1 {WHERE} ORDER BY a.pid,a.sort,a.attribute" )
                .add("userId", "AND b.user_id = @userId",
                        "{INNER}", "INNER JOIN pd_user_role AS b ON ra.role_id = b.role_id")
                .add("role", " AND ra.role_id = @role")
                .add("authority", " AND ra.authority_id = @authority")
                .add("platformType", " AND a.platform_type = @platformType")
        ;

    }

}
