package com.tcm.system.role.web;

import com.tcm.system.role.service.TcmRoleService;
import com.tcm.system.role.vo.req.TcmRolePageReqVo;
import com.tcm.system.role.vo.res.TcmRoleListResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/roles")
public class TcmRoleController {

    private TcmRoleService tcmRoleService;

    public TcmRoleController(TcmRoleService tcmRoleService) {
        this.tcmRoleService = tcmRoleService;
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<TcmRoleListResVo>> queryList(@RequestBody TcmRolePageReqVo req){
//        CheckerHelper.newInstance()
//                .notBlankCheck("companyId",req.getCompanyId())
//                .checkException();
        return ResponseResult.result(tcmRoleService.queryList(req));
    }

}
