package com.tcm.system.user.dao.impl;

import com.tcm.system.user.dao.UserDao;
import com.tcm.system.user.vo.TcmUserVo;
import com.tcm.system.user.vo.req.TcmUserReqVo;
import com.tcm.system.user.vo.res.TcmUserResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {

    private static final String QUERY_USER = "QUERY_USER";


    @Override
    protected void init() {
        register(TcmUserVo.class);

        table.add(QUERY_USER,"select * from pd_user where 1=1")
                .add("companyId","and company_id = ? ")
                .add("account","and account = ? ")
                .add("phone","and phone = ? ")
                .add("loginAccount","and (account = ? or phone = ?) ")
                .add("roleId"," id in (select user_id from pd_user_role where role_id = ? )");
    }

    @Override
    public TcmUserResVo queryUser(TcmUserReqVo req) {
        return this.queryFirst(TcmUserResVo.class, QUERY_USER, req);
    }
}
